export interface PodMakeOrderData {
  data?: OrderData | null
  warehouseId?: number
  fromUser?: number | string
  box?: number
  addDate?: string
}

export interface OrderData {
  shipmentsNote?: string
  filePath?: string
  fileData?: string
  logisticsWayName?: string | null
  company?: string | null
  orderStatus?: number
  fromUser?: string | number
  salesPlatform?: string
  logisticsCompanyId?: number
  blocked?: boolean
  logisticsCompanyName?: string
  logisticsWayNameId?: number
  shopNumber?: string
  id?: number
  shopId?: number
  systemWeight?: number
  trackingNumber?: string
  productList?: ProductList[]
  purchaseNumber?: number
  pickingNumber?: number
  printResult?: string
  remark?: string
  version?: number
  factoryOrderNumber?: number | string
  replaceShipment?: number | string
  orderParamList?: IorderItem[]
}
export interface IorderItem {
  id: number
  dataVersion: number
}
export interface ProductList {
  warehouseSkuImage: string
  warehouseSku: string
  orderItemId: string
  warehouseSkuName: string
  productMark: string
  podJomallNo: string
  id: number
  mainSku: string
  imageAry: string
  purchaseNumber: number
  count?: number
  power?: boolean
  variantImage?: string
  podJomallUsNo?: string
  podJomallCnNo?: string
  thirdSkuCode?: string
  previewImgs?: { sort?: string | number; title?: string; url: string }[]
}

export interface LogisticBill {
  expressSheet?: string
  salesPlatform?: string
  orderStatus?: string
  shopWay?: string
  blocked?: boolean
  logisticsCompanyName?: string
  logisticsWayNameId?: string
  shopNumber?: string
  id?: string
  shopId?: string
  orderId?: string
  orderNumber?: string
  trackingNumber?: string
  systemWeight?: number | string
  purchaseNumber?: number
  productList?: ProductList[]
}
