import { BasePaginationData, BaseRespData } from '@/types/api'
import axios from './axios'
import { LoginReq, LoginResp } from '@/types/api/auth'
import {
  UserEditForm,
  userData,
  customSearchForm,
  userSearchForm,
  customData,
} from '@/types/api/user'
import { NameSpaceList } from '@/types/api/deliveryNote'

export function loginApi(data: LoginReq) {
  return axios.post<never, LoginResp>('/factory/login', data)
}

// 修改密码
export function changePasswordApi(data: { oldPwd: string; newPwd: string }) {
  return axios.post<never, BaseRespData<never>>(
    'factory/factoryUser/updatePassword',
    data,
  )
}
// 用户列表
export function getUserList(
  data: userSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<userData>>(
    '/factory/factoryUser/list_page',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}
// 新增用户
export function addUserApi(form: UserEditForm) {
  return axios.post<never, BaseRespData<never>>('/factory/factoryUser/add', {
    ...form,
  })
}

// 编辑用户
export function updateUserApi(form: UserEditForm) {
  return axios.post<never, BaseRespData<never>>('/factory/factoryUser/update', {
    ...form,
  })
}

// 删除用户
export function deleteUserApi(ids: string) {
  return axios.get<never, BaseRespData<never>>('/factory/factoryUser/delete', {
    params: { ids: ids },
  })
}
export function getRelList(
  data: customSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<customData>>(
    '/dbDiyUser/getRelList',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}
export function getBySkuApi(sku: string) {
  return axios.get<never, BaseRespData<customSearchForm>>(
    '/dbDiyUser/getBySku',
    {
      params: { sku: sku },
    },
  )
}
export function addRelApi(userId?: number | string) {
  return axios.get<never, BaseRespData<never>>('/dbDiyUser/addRel', {
    params: { userId: userId },
  })
}
export function removeRelApi(relId?: number) {
  return axios.get<never, BaseRespData<never>>('/dbDiyUser/removeRel', {
    params: { relId: relId },
  })
}
export function getDetailsByIdApi(id: number) {
  return axios.get<never, BaseRespData<UserEditForm>>(
    '/factory/factoryUser/get',
    {
      params: {
        id,
      },
    },
  )
}
interface ResetPasswordRespData {
  passWord: string
}
export function resetPasswordApi(id: number) {
  return axios.get<never, BaseRespData<ResetPasswordRespData>>(
    `factory/factoryUser/resetPassword/${id}`,
  )
}
// 切换用户状态
export function changeUserStatusApi(status: number, id: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/factoryUser/enableDisable',
    {
      params: {
        status,
        id,
      },
    },
  )
}

export function getUserNameSpaceList() {
  return axios.get<never, BaseRespData<NameSpaceList[]>>('dbDiyUser/getList')
}
export function getUserMarkList() {
  return axios.get<never, BaseRespData<string[]>>(
    'factory/customJomallOrder/getUserMarkList',
  )
}
