import axios from './axios'
import { BasePaginationData } from '@/types/api'
import { SearchForm, OutOfStockItem } from '@/types/api/outOfStockStatistics'
export function getOutOfStockStatisticsListApi(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<OutOfStockItem>>(
    'stockOutStatistics/getStockOutStatistics',
    { ...data, currentPage, pageSize },
  )
}
