import type { TableColumnCtx } from 'element-plus'

export interface SearchForm {
  mainSku: string
  endProductId: string
  orderNumber: string
  shopNumber: string
  timeType: string | null
  startTime?: string | null
  endTime?: string | null
  logisticsTracking: string
  lanshouName: string
  billNumber: string
  internalMemo: string
  status?: number
  subOrderNumber: string
  order: string
}

export interface Tab {
  status: string
  statusCode: number
  statusName: string
  quantity: number
}

export interface OrderData {
  id: number
  namespace?: string
  factoryNo?: string
  erpId?: number
  thirdProductAmount?: number
  count?: number
  orderNumber?: string
  erpOrderNumber?: string
  userMark?: string
  facotoryNo?: string
  addressId?: number
  erpSubOrderNumber?: string
  orderOnlineId?: number
  orderOnlineNo?: number
  status?: number
  weight?: number
  outCurrencyCode?: number
  carriageAmount?: number
  totalAmount?: number
  productNum?: number
  trackStatus?: string
  finishTime?: string
  paymentTime?: string
  remark?: string
  manuscriptUrl?: string
  startStockingTime?: string
  source?: string
  substrateAreaCode?: string
  deliveryType?: string
  lanshouName?: string
  lanshouPhone?: string
  lanshouRegion?: string
  lanshouAddress?: string
  lanshouPost?: string
  totolBuyNumber?: string
  updateTime?: string
  createTime?: string
  productAmount?: string
  internalMemoList?: MemoList[]
  substrateAreaName?: string
  productList?: ProductList[]
  detailList?: ProductList[]
  delayMinDay?: number
  shipmentList?: string
  sourceType?: string
  moreable?: boolean
  manuscriptStatus?: number
  factoryOrderNumber?: string | undefined
}
export interface ProductList {
  id: number
  customOrderId?: number
  orderNumber?: string
  subOrderNumber?: string
  shopNumber?: string
  material?: string
  materialPrice?: number | null
  count?: number
  baseSku?: string
  erpSubOrderNumber?: string
  variantSku?: string
  variantImage?: string
  erpProductItemId?: number
  endProductId?: string
  chimaId?: string
  diyId?: string
  facotoryNo?: string
  num?: number
  shipmentNum?: number
  price?: number
  productName?: string
  createTime?: string
  updateTime?: string
  version?: string | number
  passNum?: number
  process?: string | null
  processName?: string | null
  remark?: string | null
  notPassNum?: number
  sendOutQuantity?: number
  factoryOrderNumber?: string | undefined
  thirdSubOrderNumber?: string
  namespace?: string
  factorySubOrderNumber?: string
  podOrderId?: number | string
  isProduction?: boolean
  imageAry?: string
  productionFileId?: string
}

export interface MemoList {
  id: number
  type?: number
  outId?: number
  operatorEmployeeName?: string
  content?: string
  remark?: string
  operatorTime?: string
}

export interface SpanMethodProps {
  row: OrderData
  column: TableColumnCtx<OrderData>
  rowIndex: number
  columnIndex: number
}

export interface ShipmentForm {
  shippingWay: string
  carriageName: string
  logisticsTracking: string
  carriageAmount: string
  namespace?: string
}

export interface ShipmentOrderRes {
  subOrderNumber?: string
  erpSubOrderNumber?: string
  sendOutQuantity?: number
  version?: string | number
}

export interface LogisticsData {
  id: number
  code: string
  enName: number
  name: string
  typeCode: number
}

export interface SendOrderData {
  id: number
  billNumber?: string
  shippingWay?: number
  addressId?: number
  carriageAmount?: number
  carriageName?: string
  logisticsTracking?: string
  shippingStatus?: number
  lanshouName?: string
  lanshouPhone?: string
  lanshouRegion?: string
  lanshouAddress?: string
  lanshouPost?: string
  updateTime?: string
  createTime?: string
  detailList?: DetailList[]
}

export interface DetailList {
  id: number
  shipmentId?: number
  customOrderId?: number
  subOrderNumber?: string
  baseSku?: string
  variantSku?: string
  variantImage?: string
  shipmentNum?: number
  updateTime?: string
  createTime?: string
  productionNum?: number
  notShipmentNum?: number
  productName?: string
  facotoryNo?: string
  notPassNum?: number
  passNum?: number
}

export interface LogListData {
  id: number
  bizId?: number
  userId?: number
  employeeName?: string
  description?: string
  createTime?: string
}

export interface QaData {
  orderNumber?: string
  namespace?: string
  scansNum?: number
  shipmentUid?: string
  billNumber?: string
  subOrderNumber?: string
  baseSku?: string
  variantSku?: string
  variantImage?: string
  num?: number
  shipmentNum?: number
  shippingWay?: number
  productName?: string
  logisticsTracking?: string
  lanshouName?: string
  lanshouPhone?: string
  lanshouRegion?: string
  lanshouAddress?: string
  lanshouPost?: string
  passNum?: number
  notPassNum?: number
  version?: number
  factorySubOrderNumber?: string
  inspectionStatus?: boolean
  source?: string
  sourceType?: string
  isCheck?: boolean
  erpSubOrderNumber?: string
  remark?: string | null
}

export interface InspectionData {
  notPassCount: number | string
  subOrderNumber: string
  namespace: string
  erpSubOrderNumber: string
  billNumber: string
  version: number | string
  passCount: number | string
}

export interface Reconciliation {
  status: string | number | null
  startTime: string
  endTime: string
  billNumber?: string
  shipmentId?: string
  shipmentNum?: string
  dataVersion?: string
  carriageName?: string
  lanshouAddress?: string
  totalPrice?: string
  passNum?: string
  lanshouPost?: string
  notPassNum?: string
  lanshouRegion?: string
  orderNumber?: string
  lanshouName?: string
  lanshouPhone?: string
  logisticsTracking?: string
  totalAmount?: string
  id?: number
}
export interface shopRemark {
  resendNum?: number | undefined | null
  remark?: string | undefined | null
}
export interface ICompareObjects {
  lanshouAddress?: string
  lanshouName?: string
  lanshouPhone?: string
  lanshouPost?: string
  lanshouRegion?: string
}
export interface PaymentForm {
  waterList: string
  id?: number | string
  actualAmount?: number | string
  payableAmount?: number | string
  recNumber?: number | string
}
export interface RejectParams {
  id: number
  description?: string
  ids?: string
  pass?: number
}
