import { BaseRespData } from '@/types/api'
import axios from './axios'
import { LogisticsData } from '@/types/api/order'
import { userData } from '@/types/api/user'
import { VersionImageList } from '@/types/api/typesetting'

// 获取物流公司
export function getLogisticsCompanyList() {
  return axios.get<never, BaseRespData<LogisticsData[]>>(
    'factory/customJomallOrder/getLogisticsList',
  )
}
// 获取客户
export function getUserMarkList() {
  return axios.get<never, BaseRespData<string[]>>(
    'dbDiyUser/getUserMarkList',
  )
}

// 获取用户
export function getUserListApi() {
  return axios.get<never, BaseRespData<userData[]>>('factory/factoryUser/list')
}

// 上传图片文件
export function uploadImageApi(data: FormData) {
  return axios.post<never, BaseRespData<never> & VersionImageList>(
    'upload/ossUpload',
    data,
  )
}
export function uploadFileApi(data: FormData) {
  return axios.post<never, BaseRespData<VersionImageList>>(
    'supply/supplyTypesettingInfo/uploadManuscript',
    data,
  )
}
