export interface TreeData {
  statusName: string
  children?: TreeData[]
  statusCode: string
  quantity?: number
}

export interface TypesettingListData {
  id: number
  sku?: string
  homeSku?: string
  productName?: string
  mainImage?: string
  categoryId?: number
  status?: string
  state?: number | string
  type?: number
  shelve?: number
  printType?: number
  scImgType?: number
  openly?: number
  imageList?: ImageListData[]
  retailPrice?: number
  urgentLevel?: number
  expectCompleteTime?: string
  promiseCompleteTime?: string
  requirement?: string
  confirm?: boolean
  personInChargeId?: number
  personInChargeName?: string
  createTime?: string
  updateTime?: string
  assignmentTime?: string
  paperFile?:string|null
}

export interface SearchForm {
  pageSize: number
  currentPage: number
  sku: string
  state?: string
}

export interface EmergencyLevel {
  name: string
  desc: string
  value: number
}

export interface VersionImageList {
  imagePath?: string
  filePath?: string
  sort: number
  version?: string
}

export interface VersionList {
  id?: number
  typesettingId?: number
  opinion?: string
  examinePeopleId?: string
  examinePeopleName?: string
  fabric?:string
  state?: number
  version?: number
  createTime?: string
  updateTime?: string
  examineImages: ExamineImage[]
  examine?: string
}

export interface ExamineImage {
  id: number
  typesettingId: number
  typesettingExamineId?: number
  imagePath: string
  zimagePath?: string
  sort: number
  createTime?: string
  updateTime?: string
}

export interface PriceForm {
  id?: number
  supplyTypesettingId?: number
  craftImage?: string
  bulkUnitPrice?: string
  testUnitPrice?: string
  deliveryDay?: number
  priceOpinion?: string
  priceNote?: string
  updateTime?: string
  createTime?: string
  flag?: boolean
}

export interface LogList {
  id: number
  supplyTypesettingId: number
  supplyTypesettingStatus: string
  employeeId: number
  description: string
  createdTime: string
  createTime?: string
}

export interface ImageListData {
  id: number
  imagePath: string
  filePath?: string
  sort: number
}
