import { Ref, ref } from 'vue'
import { cloneDeep } from 'lodash-es'

export function useValue<T extends object>(
  initialValue: T,
): [Ref<T>, () => void] {
  const value = ref<T>(cloneDeep(initialValue)) as Ref<T>

  const resetToDefault = () => {
    value.value = cloneDeep(initialValue)
  }

  return [value, resetToDefault]
}
