export interface Tab {
  status?: string
  statusName?: string
  quantity?: number
}
export interface IconfirmSubmit {
  ids: string
  warehouseId: number | null
  warehouseName: string
}
export interface ExportParams extends SearchForm {
  idList?: number[]
  exportAll: boolean
}
export interface SearchForm {
  timeType?: number | null
  shopNumber?: string
  productMark?: string
  shipmentType?: string | number
  replaceShipment?: string | number
  userMark?: string
  processNumber?: string
  trackingNumber?: string
  baseSku?: string
  factoryOrderNumber?: string
  sku?: string
  order?: string
  factorySubOrderNumber?: string
  status?: string
  customizedQuantity?: string
  multi?: boolean | null
  startTime?: string | null
  endTime?: string | null
  shipmentArea?: number | undefined
  platform?: string
  productionClient?: string
  warehouseId?: string | number
  thirdSkuCode?: string
  supplierProductNo?: string
  batchArrangeNumber?: string
  craftCode?: string[] | string
  thirdStockSku?: string
  exceptionHandling?: number | undefined
  interceptStatus?: number | string
  sizeType?: number | null
  tagsId?: string
  source?: string
  tagsIdArr?: (number | null)[]
}
export interface PodCnOrderListData {
  id: number
  thirdOrderNumber?: string
  factoryOrderNumber?: string
  shopNumber?: string
  factoryOnlineId?: number | null
  factoryNo?: number | null
  factoryCode?: string | null
  status?: string
  weight?: number | null
  totalProductAmount?: number | null
  productAmount?: number
  carriageAmount?: number | null
  totalAmount?: number | null
  productNum?: number | null
  trackStatus?: string | null
  receiverName?: string
  receiverPhone?: string
  receiverCountry?: string
  receiverProvince?: string
  receiverCity?: string
  receiverDistrict?: string
  receiverAddress1?: string
  receiverAddress2?: string
  receiverPostCode?: string
  paymentType?: string
  paymentTime?: string
  startStockingTime?: string
  finishTime?: string
  shipmentType?: number
  expressSheet?: string
  trackingNumber?: string
  processNumber?: string
  createTime?: string
  updateTime?: string
  remark?: string | null
  userMark?: string
  serviceAmount?: number | null
  prepaidAmount?: number | null
  actualAmount?: number | null
  version?: number
  productList?: ProductList[]
  orderNumber?: string
  logisticsWayId?: number | null
  logisticsWayName?: string
  url?: string | null
  tiffUrl?: string | null
  customTagList?: { name: string }[]
}
export interface ProductList {
  id: number
  podJomallOrderCnId: number
  productMark?: string
  thirdSubOrderNumber?: string
  thirdStockSku?: string
  factorySubOrderNumber?: string
  factoryCode?: string
  productName?: string
  baseSku?: string
  variantSku?: string
  productPrice?: number
  templatePrice?: number
  variantImage?: string
  craftPrice?: number
  craftCode?: string
  previewImgs?: []
  platform?: string
  imageAry?: string
  designImages?: string
  categoryId?: number
  categoryName?: string
  num?: number
  passNum?: number
  notPassNum?: number
  payAmount?: number
  status?: number
  weight?: number | null
  diyId?: string
  endProductId?: string
  customizedQuantity?: number
  tagIds?: string
  isProduction?: boolean
  createTime?: string
  updateTime?: string
  remark?: string | null
  version?: number
  subOrderNumber?: string
  craftName?: string | null
  lanshouAddress?: string | null
  shopNumber?: string | null
  factoryOrderNumber?: string | null
  replenishmentNum?: number | null
  isReplenishment?: boolean
  thirdSkuCode?: string | null
  supplierProductNo?: string | null
  userMark?: string | null
  replenishmentSumNum?: number | null
  interceptStatus?: number | null
  batchArrangeNumber?: string | null
  sizeType?: number | null
  customTagList?: { name: string }[]
}
export interface cardImages {
  title: string
  url: string
  sort: number
  id?: number
}
export interface LogListData {
  id: number
  bizId: number
  userId: number
  employeeName: string
  description: string
  deleteContent: string
  createTime: string
}
export interface ProductionClient {
  code?: string
  remark?: string
}
export interface PodOrderRes extends ProductList {
  expectDeliveryTime?: string | null
  thirdOrderNumber?: string | null
  startStockingTime?: string | null
  factoryOrderNumber?: string | null
  userMark?: string | null
  craftName?: string | null
  craftId?: string | null
  shopNumber?: string | null
  color?: string | null
  size?: string | null
  note?: Array<{ prop: string | number; value: string | number }>
  imgList: cardImages[]
}
export interface WarehouseListData {
  code?: string
  defaulted?: number
  factoryCode?: string
  factoryId?: number
  id: number
  name?: string
  remarks?: string
  sort?: number
}
export interface LogisticsData {
  logisticsWayName: string // 物流名称
  warehouseName: string // 发货仓库
  status: boolean
  logisticsWayCode: string // 物流编码
  partition: string // 所在分区
  logisticsWayId?: number | null
}
export interface AddressInfo {
  id?: string
  receiverName: string
  receiverPhone: string
  receiverCountry: string
  receiverProvince: string
  receiverCity: string
  receiverDistrict: string
  receiverAddress1: string
  receiverAddress2: string
  receiverPostCode: string
}
export interface LogisticsFormData {
  processNumber: string
  trackingNumber: string
  expressSheetUrl: string
  expressSheet: File | null
}
export interface CraftListData {
  craftName: string
  craftCode: string
  craftType: string
}
export interface PackingData {
  podProductionNo?: string // 生产单号（PSCD 开头）
  jomallCustomNo?: string // 一件定制号（16 位数字 或 S- 开头）
  jomallPsdCustomNo?: string // 满印定制号（JMSC/GCSC 开头）
  podJomallNo?: string // POD 平台号（JMPSC/GCPS 经过正则提取）
  sku?: string // 普通 SKU（兜底）
}
