import axios from './axios'
import { BasePaginationData, BaseRespData } from '@/types/api'
import {
  TypesettingListData,
  SearchForm,
  LogList,
} from '@/types/api/typesetting'
import type {
  PriceForm,
  TreeData,
  VersionImageList,
  VersionList,
} from '@/types/api/typesetting'
export function getTypeListApi(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<TypesettingListData>>(
    'supply/supplyTypesettingInfo/list_page',
    { ...data, currentPage, pageSize },
  )
}

export function getStatusListApi() {
  return axios.get<never, BaseRespData<TreeData[]>>(
    'supply/supplyTypesettingInfo/findStateGroupList',
  )
}

export function getTypesettingDetail(id: number) {
  return axios.get<never, BaseRespData<never>>(
    'supply/supplyTypesettingInfo/get',
    {
      params: {
        id,
      },
    },
  )
}

export function saveTypesettingReviewApi(data: TypesettingListData) {
  return axios.post<never, BaseRespData<never>>(
    'supply/supplyTypesettingInfo/supplierConfirm',
    data,
  )
}

export function submitReviewApi(
  typesettingId: number,
  version: number,
  examineImages: VersionImageList[],
  fabric: string,
) {
  return axios.post<never, BaseRespData<never>>(
    'supply/supplyTypesettingExamine/submitExamine',
    {
      typesettingId,
      version,
      examineImages,
      fabric,
    },
  )
}

export function getExamineInfoByIdApi(typesettingId: number) {
  return axios.get<never, BaseRespData<VersionList[]>>(
    'supply/supplyTypesettingExamine/getByTypesettingId',
    {
      params: {
        typesettingId,
      },
    },
  )
}

export function submitReviewOpinionApi(
  typesettingId: number,
  examine: boolean,
  opinion: string,
  id?: number,
) {
  return axios.post<never, BaseRespData<never>>(
    'supply/supplyTypesettingExamine/examine',
    {
      typesettingId,
      examine,
      opinion,
      id,
    },
  )
}
export function submitReviewPriceInfoApi(id: number, data: PriceForm) {
  return axios.post<never, BaseRespData<never>>(
    'supply/supplyTypesettingPrice/saveQuotedPrice',
    {
      ...data,
      typesettingId: id,
    },
  )
}

export function getTypesettingLogByIdApi(id: number) {
  return axios.get<never, BaseRespData<LogList[]>>(
    'supply/supplyTypesettingInfo/getLogList',
    {
      params: { id },
    },
  )
}

export function rejectDataApi(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    'supply/supplyTypesettingInfo/batchReject',
    {
      params: {
        ids,
      },
    },
  )
}
export function getPriceDetailApi(id: number) {
  return axios.get<never, BaseRespData<PriceForm>>(
    'supply/supplyTypesettingPrice/getPriceDetail',
    {
      params: {
        id,
      },
    },
  )
}
