import { get } from 'lodash-es'
import { ElMessage } from 'element-plus'
import { DateTime } from 'luxon'
import usePermissionBtnStore from '@/store/permission'

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export function val<T>(data: T, key: string | ((data: T) => any)) {
  if (typeof key === 'function') return key(data)
  return get(data, key)
}

/**
 * @param {*} text
 */
export function copyText(text: string) {
  const oInput = document.createElement('input')
  oInput.value = text
  document.body.appendChild(oInput)
  oInput.select() // 选择对象
  document.execCommand('Copy') // 执行浏览器复制命令
  oInput.className = 'oInput'
  oInput.style.display = 'none'
  document.body.removeChild(oInput)
  ElMessage.success('复制成功')
}

/**
 * 将本地时间转换为北京时间（自动检测时区）
 * @param {string} localTime - 本地时间字符串，格式 YYYY-MM-DD HH:mm:ss
 * @returns {string} 北京时间，格式 YYYY-MM-DD HH:mm:ss
 */
export function convertToChinaTime(
  timeString: string,
  currentZone: string = 'local',
  targetZone: string = 'Asia/Shanghai',
) {
  // 将输入的时间字符串解析为本地时间，假设输入时间是本地时间
  const inputTime = DateTime.fromFormat(timeString, 'yyyy-MM-dd HH:mm:ss', {
    zone: currentZone,
  })

  const chinaTime = inputTime.setZone(targetZone)
  return chinaTime.toFormat('yyyy-MM-dd HH:mm:ss')
}

export function isPermissionBtn(key: string) {
  const permissionBtns = usePermissionBtnStore().permissionBtns

  if (!permissionBtns) return false
  return permissionBtns.includes(key)
}
