export interface CountStatus {
  id?: number
  code?: number
  count?: number
  remark?: string
  children?: CountStatus[]
}
export interface AccountStatementNoteSearchForm {
  user_mark?: string
  status?: number | string | null
  dateRange?: string[]
  billNumber?: string
  subOrderNumber?: string
  shipmentNumber?: string
  recNumber?: string
  orderNumber?: string
  factory_status?: string
  erp_status?: string
  startTime?: string
  start_time?: string
  endTime?: string
  end_time?: string
}

export interface AccountStatementNoteSearchFormUS {
  user_mark?: string
  status?: number | string | null
  dateRange?: string[]
  billNumber?: string
  subOrderNumber?: string
  shipmentNumber?: string
  rec_number?: string
  order_number?: string
  factory_status?: string
  erp_status?: string
  startTime?: string
  start_time?: string
  endTime?: string
  end_time?: string
}

export interface AccountStatementNote {
  create_time?: string
  product_total_amount?: number
  craft_total_amount?: number
  pass_num?: number
  factory_code?: string
  total_amount?: string | number
  totalAmount?: string | number
  actual_amount?: string | number
  num?: number
  end_time?: string
  rec_number?: string
  not_pass_num?: number
  factory_id?: number
  start_time?: string
  carriage_total_amount?: number
  factory_status?: number
  factory_total_amount?: number
  user_mark?: string
  erp_status?: number
  id?: number
  erp_total_amount?: number
  dataVersion: ''
  water_list?: {
    url: string | undefined
  }[]
}
export interface BillOrderDetailData {
  create_time?: string
  pass_num: number
  factory_code?: string
  num?: number
  end_time?: string
  rec_number?: string
  not_pass_num?: number
  factory_id?: number
  start_time?: string
  carriage_total_amount?: number
  factory_status?: number
  factory_total_amount: number
  user_mark?: string
  logList?: LogList[]
  erp_status?: number
  itemList?: ItemList[]
  id: number
  erp_total_amount?: number
}

export interface LogList {
  create_time?: string
  info_id?: number
  id: string
  diy_id: number
  employee_account?: string
  employee_name?: string
  employee_id?: string
  description?: string
}

export interface ItemList {
  carriage_amount?: number
  pass_num?: number
  num?: number
  factory_price?: number
  shipment_id?: string
  not_pass_num?: number
  erp_order_number?: string
  shipment_time?: string
  bill_number?: string
  erp_price?: number
  info_id?: number
  id: number
  factory_order_number?: string
}
export interface OrderDetails {
  pass_num: number
  num: number
  not_pass_num: number
  erp_order_number: string | null
  product_total_amount: number
  carriage_total_amount: number
  craft_total_price: number
  info_id: number
  template_total_price: number
  id: number
  order_id: string
  factory_order_number: string
  order: {
    receiver_post_code: string
    payment_time: string | null
    actual_amount: number
    adjusted_amount: number
    factory_no: number
    factory_online_id: string | null
    total_product_amount: number | null
    process_number: string
    track_status: number
    id: string
    receiver_country: string
    factory_order_number: string
    prepaid_amount: number
    receiver_province: string
    create_time: string
    weight: number
    product_num: number
    version: number
    finish_time: string
    start_stocking_time: string
    payment_type: string | null
    warehouse_name: string
    total_amount: number
    logistics_way_code: string
    third_order_number: string
    shop_number: string
    express_sheet: string
    status: string
    production_client: string
    statusStr: string
    receiver_city: string
    remark: string | null
    exception_reason: string | null
    platform: string
    update_time: string
    receiver_address2: string
    receiver_address1: string
    receiver_name: string
    tracking_number: string
    product_amount: number
    carriage_amount: number | null
    pay_freight: number
    logistics_way_name: string
    factory_code: string
    receiver_district: string | null
    temu_logistics_way_id: string | null
    logistics_way_id: number
    user_mark: string
    namespace: string
    receiver_phone: string
    exception_handling: number
    shipment_type: number
    warehouse_id: number
  }
}
export interface ProductDetails {
  diy_id: string
  diy_bianma: string
  base_sku: string
  sub_order_number: string
  price_update_remark: string | null
  price_status: boolean
  template_item_sku: string | null
  product_id: string
  id: number
  shipment_num: number
  product_item_id: string | null
  template_price: number
  product: {
    diy_id: string
    end_product_id: string
    category_name: string
    craft_name: string
    base_sku: string
    num: number
    is_production: boolean
    pick_finish: number
    remark: string | null
    product_price: number
    third_stock_sku: string | null
    customized_quantity: number
    template_price: number
    tag_ids: string | null
    create_time: string
    third_sub_order_number: string
    factory_sub_order_number: string
    variant_image: string
    craft_code: string
    pass_num: number
    factory_code: string
    pay_amount: number
    weight: number
    is_replenishment: number
    image_ary: Array<{ title: string; url: string }>
    design_images: Array<{
      imageUrl: string
      fileUrl: string
      id: string
      title: string
      materialId: string
      materialImage: string
    }>
    not_pass_num: number
    version: number
    supplier_product_no: string | null
    pod_jomall_order_us_id: string
    craft_price: number
    customs_value: number
    variant_sku: string
    batch_arrange_number: string
    trim_design_images: string | null
  }
  product_item_sku: string | null
  item_id: number
  variant_image: string
  pass_num: number
  not_pass_num: number | null
  craft_price: number
  price_update_time: string | null
  variant_sku: string
  info_id: number
  shop_number: string
  template_item_id: string | null
  order_id: string
}

export interface ConfirmOrderForm {
  pass?: number | null
  description?: string
  ids?: string
}
