import { get } from 'lodash-es'
import { ElMessage } from 'element-plus'
// eslint-disable-next-line @typescript-eslint/no-explicit-any
export function val<T>(data: T, key: string | ((data: T) => any)) {
  if (typeof key === 'function') return key(data)
  return get(data, key)
}

/**
 * @param {*} text
 */
export function copyText(text: string) {
  const oInput = document.createElement('input')
  oInput.value = text
  document.body.appendChild(oInput)
  oInput.select() // 选择对象
  document.execCommand('Copy') // 执行浏览器复制命令
  oInput.className = 'oInput'
  oInput.style.display = 'none'
  document.body.removeChild(oInput)
  ElMessage.success('复制成功')
}
