export interface Tab {
  status?: string
  statusName?: string
  quantity?: number
}
export interface SearchForm {
  timeType: number | null
  shopNumber: string
  userMark: string
  logisticsTracking: string
  baseSku: string
  factoryOrderNumber: string
  sku: string
  factorySubOrderNumber: string
  status: string
  customizedQuantity: string
  startTime: string | null
  endTime: string | null
}
export interface PodUsOrderListData {
  id: number
  thirdOrderNumber?: string
  factoryOrderNumber?: string
  shopNumber?: string
  factoryOnlineId?: number | null
  factoryNo?: number | null
  factoryCode?: string | null
  status?: string
  weight?: number | null
  totalProductAmount?: number | null
  productAmount?: number
  carriageAmount?: number | null
  totalAmount?: number | null
  productNum?: number | null
  trackStatus?: string | null
  receiverName?: string
  receiverPhone?: string
  receiverCountry?: string
  receiverProvince?: string
  receiverCity?: string
  receiverDistrict?: string
  receiverAddress1?: string
  receiverAddress2?: string
  receiverPostCode?: string
  paymentType?: string
  paymentTime?: string
  startStockingTime?: string
  finishTime?: string
  shipmentType?: string
  expressSheet?: string
  trackingNumber?: string
  processNumber?: string
  createTime?: string
  updateTime?: string
  remark?: string | null
  userMark?: string
  version?: number
  productList?: ProductList[]
  orderNumber?: string
}
export interface ProductList {
  id: number
  podJomallOrderUsId: number
  thirdSubOrderNumber?: string
  factorySubOrderNumber?: string
  factoryCode?: string
  productName?: string
  baseSku?: string
  variantSku?: string
  productPrice?: number
  templatePrice?: number
  variantImage?: string
  craftPrice?: number
  imageAry?: string
  designImages?: string
  categoryId?: number
  categoryName?: string
  num?: number
  passNum?: number
  notPassNum?: number
  payAmount?: number
  status?: number
  weight?: number | null
  diyId?: string
  endProductId?: string
  customizedQuantity?: number
  tagIds?: string
  isProduction?: boolean
  createTime?: string
  updateTime?: string
  remark?: string | null
  version?: number
  subOrderNumber?: string
  craftName?: string | null
  lanshouAddress?: string | null
  shopNumber?: string | null
  factoryOrderNumber?: string | null
}
export interface cardImages {
  title: string
  url: string
  sort: number
  id?: number
}
export interface LogListData {
  id: number
  bizId: number
  userId: number
  employeeName: string
  description: string
  deleteContent: string
  createTime: string
}
export interface ProductionClient {
  code?: string
  remark?: string
}
export interface PodOrderRes extends ProductList {
  expectDeliveryTime?: string | null
  thirdOrderNumber?: string | null
  startStockingTime?: string | null
  factoryOrderNumber?: string | null
  userMark?: string | null
  craftName?: string | null
  craftId?: string | null
  shopNumber?: string | null
  color?: string | null
  size?: string | null
  note?: Array<{ prop: string | number; value: string | number }>
  imgList: cardImages[]
}
export interface WarehouseListData {
  code?: string
  defaulted?: number
  factoryCode?: string
  factoryId?: number
  id: number
  name?: string
  remarks?: string
  sort?: number
}
