import { BasePaginationData, BaseRespData } from '@/types/api'
import {
  ProductList,
  PodUsOrderListData,
  SearchForm,
  Tab,
  LogListData,
  ProductionClient,
  WarehouseListData,
} from '@/types/api/podUsOrder'
import axios from './axios'
import { PodMakeOrderData } from '@/types/api/podMakeOrder'
export interface LogisticsData {
  logisticsWayName: string // 物流名称
  warehouseName: string // 发货仓库
  status: boolean
  logisticsWayCode: string // 物流编码
  partition: string // 所在分区
}
export function getOrderTabData() {
  return axios.get<never, BaseRespData<Tab[]>>(
    '/factory/podJomallOrderUs/findStateGroupList',
  )
}
export function getOrderList(
  params: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<PodUsOrderListData[]>>(
    '/factory/podJomallOrderUs/list_page',
    {
      ...params,
      currentPage,
      pageSize,
    },
  )
}
export function getCardOrderList(
  params: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<ProductList[]>>(
    '/factory/podJomallOrderProductUs/list_page',
    {
      ...params,
      currentPage,
      pageSize,
    },
  )
}
export function confirmOrderApi(
  data: number[],
  productionClient: string,
  type: string,
  logisticsTrialCalculation?: LogisticsData | null,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/confirmOrders',
    {
      ids: data.join(','),
      type,
      logisticsTrialCalculation,
      productionClient,
    },
  )
}
export function getProductionClientApi() {
  return axios.get<never, BaseRespData<ProductionClient[]>>(
    'factory/podJomallOrderUs/getProductionClientList',
  )
}
export function updateExceptionOrderApi(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/updateExceptionOrders',
    {
      orderIds: data,
    },
  )
}
export function changeExceptionOrderApi(ids: number[], value: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/exceptionOrders',
    {
      orderIds: ids,
      exceptionReason: value,
    },
  )
}
export function cancelOrderApi(ids: number[], value: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/cancelOrders',
    {
      orderIds: ids,
      cancelReason: value,
    },
  )
}
export function getOperationLogApi(id: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    `factory/podJomallOrderUsLog/getPodJomallOrderUsLog?id=${id}`,
  )
}
export function getSubOrderBySubOrderNumber(factorySubOrderNumber: string) {
  return axios.get<never, BaseRespData<ProductList>>(
    'factory/podJomallOrderProductUs/getProductUsByFactorySubOrderNumber',
    {
      params: {
        factorySubOrderNumber,
      },
    },
  )
}
export function downloadMaterialApi(id: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProductUs/downloadDesignImages',
    id,
  )
}
export function productionQueryApi(id: number, podJomallOrderUsId: number) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderProductUs/completeDelivery',
    {
      id,
      podJomallOrderUsId,
    },
  )
}
export function printProductionOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderUs/printProducePdf',
    orderIds,
  )
}
export function printPrintOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderUs/printPickPdf',
    {
      ids: orderIds.join(','),
    },
  )
}
export function printPickingOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderUs/pickingComplete',
    {
      ids: orderIds.join(','),
    },
  )
}
export function stockOutCheckApi(orderIds: number[]) {
  return axios.get<never, BaseRespData<number[]>>(
    `factory/podJomallOrderUs/replenishVerify?ids=${orderIds.join(',')}`,
  )
}
export function toBeConfirmedApi(orderIds: number[]) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/updateStockOutOrderToWaitConfirmed?ids=${orderIds.join(
      ',',
    )}`,
  )
}
export function getOrderDetailById(id: number) {
  return axios.get<never, BaseRespData<ProductList>>(
    `factory/podJomallOrderProductUs/getProductUsById?id=${id}`,
  )
}
export function getPackingDataApi(
  code: string,
  factoryNo: number,
  box: number | null,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData>>(
    '/factory/podJomallOrderUs/getPodBoxDetailsBySkuOrNo',
    {
      params: {
        podJomallUsNo: code,
        box,
        factoryNo,
        warehouseId,
      },
    },
  )
}
export function getPodBoxListApi(
  factoryNo: number | string,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData[]>>(
    'factory/podJomallOrderUs/getPodBoxOrderDetails',
    {
      params: { factoryNo, warehouseId },
    },
  )
}

export function submitInspectionApi(
  data: { id: number; version?: number }[],
  boxIndex: number | null,
  warehouseId: number | string,
) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/podPrintOrderComplete?box=${boxIndex}&warehouseId=${warehouseId}`,
    {
      orderParamList: data,
    },
  )
}
export function clearBoxApi(
  factoryNo: number,
  box: number | null,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/delPodBoxOrderDetailsByBox',
    {
      params: { factoryNo, box, warehouseId },
    },
  )
}
export function clearAllBoxApi() {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/delPodBoxOrderDetails',
  )
}
export function updateRemarkApi(id: number, content: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/addRemark',
    { id, content },
  )
}

export function getLogisticsCalculation(id: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/getLogisticsCalculation',
    { params: { id } },
  )
}
export function loadWarehouseListApi() {
  return axios.get<never, BaseRespData<WarehouseListData[]>>(
    'factoryWarehouseInfo/getAll',
  )
}
export function refreshMaterialApi(orderIds: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProductUs/refreshDesignImages ',
    { orderIds },
  )
}
// 获取跟踪号
export function getTrackingNumberApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/getTrackingNumber',
    orderIds,
  )
}
// 获取打印面单
export function getfaceSimplexFileApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/getfaceSimplexFile',
    orderIds,
  )
}
// 取消物流订单
export function cancelLogisticsOrderApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/cancelLogisticsOrder',
    orderIds,
  )
}
