import type { ElMessageBoxOptions } from 'element-plus'
// 错误消息
export function showError(err: unknown, options?: ElMessageBoxOptions) {
  let message: string | undefined
  if (typeof err === 'string') message = err
  else if (
    err &&
    typeof err === 'object' &&
    'message' in err &&
    typeof err.message === 'string'
  ) {
    message = err.message
  }
  if (!message) return

  return ElMessageBox.alert(
    '<div style="max-height:500px;overflow:auto;overflow-wrap:break-word;max-width:360px;">' +
      message +
      '</div>',
    '错误提示',
    {
      type: 'error',
      ...options,
      dangerouslyUseHTMLString: true,
    },
  ).catch(() => {})
}

// 确认
export function showConfirm(message: string, options?: ElMessageBoxOptions) {
  return ElMessageBox.confirm(message, '提示', {
    ...options,
  })
}
