export interface LogisticsMethod {
  id?: number | string
  name?: string
  warehouseId?: number
  warehouseName?: string
  companyId?: number
  company?: string
  serviceCode?: string
  siteUrl?: string
  status: number | string
  platformList: platformObj[]
  ruleRef: ruleRefObj
  ruleId?: string | number
  ruleList?: ruleRefObj[]
  uinuinWarehouseId?: number | string | null
  companyWarehouseCode?: number | string | null
}

export interface LogisticsMethodList {
  name?: string
  status?: number | string
  serviceCode?: number | string
  pageSize: number | string
  currentPage: number | string
}

export interface UpdateLogisticsMethodStatus {
  id?: number | string
  status?: number | string
}

export interface LogisticsResponse {
  code: number
  data: {
    total: number
    size: number
    current: number
    records: LogisticsMethod[]
  }
  message: string
}

export interface platformObj {
  platform: string
  logisticsName: string | number
  showPlatform: (string | number)[]
}
interface ruleRefObj {
  ruleId: string | number
  ruleName: string | number
}
