import {
  createRouter,
  createWebHistory,
  RouteLocationNormalized,
  NavigationGuardNext,
} from 'vue-router'

import Login from '@/views/Login.vue'
import Reset from '@/views/Reset.vue'
import Home from '@/views/Home.vue'
import Dashboard from '@/views/Dashboard.vue'
import Error from '@/views/error/404.vue'
import OrderList from '@/views/order/index.vue'
import ProductionComplete from '@/views/production/complete.vue'
import { getToken } from '@/api/axios'
import UserPage from '@/views/system/UserPage.vue'
import DeliveryNotePage from '@/views/DeliveryNotePage.vue'
import AccountStatementNote from '@/views/AccountStatementNote.vue'
// import Product from '@/views/product/index.vue'
import PodBillOrder from '@/views/podBillOrder/index.vue'
import PodUsBillOrder from '@/views/podUsBillOrder/index.vue'
import TypeseetingManagement from '@/views/typesetting/TypesettingManagement.vue'
import PodOrderList from '@/views/order/pod/index.vue'
import PodDeliveryNoteList from '@/views/order/pod/deliveryOrderList.vue'
import PodUsOrderList from '@/views/order/podUs/index.vue'

import WarehouseManage from '@/views/warehouse/manage.vue'
import WarehouseWarning from '@/views/warehouse/warning.vue'
import WarehousePosition from '@/views/warehouse/position.vue'
import receiptDoc from '@/views/warehouse/receiptDoc.vue'
import issueDoc from '@/views/warehouse/issueDoc.vue'
import ExternalAuthorisationPage from '@/views/system/externalAuthorisationPage.vue'
import CustomersPage from '@/views/system/CustomersPage.vue'
const router = createRouter({
  history: createWebHistory(),
  routes: [
    {
      path: '/',
      redirect: '/user/login',
      component: Home,
      children: [
        {
          path: '/dashboard',
          meta: {
            title: '概览',
          },
          component: Dashboard,
        },
        // {
        //   path: '/product',
        //   meta: {
        //     title: '商品',
        //   },
        //   component: Product,
        // },
        {
          path: '/order/list',
          meta: {
            title: '定制订单',
          },
          component: OrderList,
        },
        {
          path: '/pod-order/list',
          meta: {
            title: 'POD订单',
          },
          component: PodOrderList,
        },
        {
          path: '/pod-cn-order/list',
          meta: {
            title: 'POD订单(CN)',
          },
          component: () => import('@/views/order/podCN/index.vue'),
        },
        {
          path: '/pod-us-order/list',
          meta: {
            title: 'POD订单(US)',
          },
          component: PodUsOrderList,
        },
        {
          path: '/pod-us-order/orderTracking',
          meta: {
            title: 'POD(US)订单跟踪',
          },
          component: () => import('@/views/order/orderTracking/index.vue'),
        },
         {
          path: '/pod-cn-order/orderTracking',
          meta: {
            title: 'POD(CN)订单跟踪',
          },
          component: () => import('@/views/order/orderTracking/indexcn.vue'),
        },
        {
          path: '/pod-delivery-note/list',
          meta: {
            title: 'POD发货单',
          },
          component: PodDeliveryNoteList,
        },
        {
          path: '/production/complete',
          meta: {
            title: '生产完成',
          },
          component: ProductionComplete,
        },
        {
          path: '/system/user',
          meta: {
            title: '用户管理',
          },
          component: UserPage,
        },
        {
          path: '/system/downloadClient',
          meta: {
            title: '下载生产客户端',
          },
          component: () => {},
          beforeEnter() {
            // 假设你的下载链接是这个
            const downloadLink = '/exeFiles/JomallProductionAssistantSetup.exe'

            // 创建一个 a 标签来触发下载
            const a = document.createElement('a')
            a.href = downloadLink
            a.download = '生产客户端.exe' // 你可以指定文件名，或者保持为空来自动使用原始文件名

            // 不显示 a 标签，直接触发下载
            a.style.display = 'none'
            document.body.appendChild(a)
            a.click()
            document.body.removeChild(a)
          },
        },
        {
          path: '/system/external-authorisation',
          meta: {
            title: '外部授权',
          },
          component: ExternalAuthorisationPage,
        },
        {
          path: '/system/customers',
          meta: {
            title: '客户管理',
          },
          component: CustomersPage,
        },
        {
          path: '/system/delivery-note',
          meta: {
            title: '定制发货单',
          },
          component: DeliveryNotePage,
        },
        {
          path: '/account/statement-note',
          meta: {
            title: '定制对账单',
          },
          component: AccountStatementNote,
        },
        {
          path: '/account/pod-bill-order',
          meta: {
            title: 'POD(CN)对账单',
          },
          component: PodBillOrder,
        },
        {
          path: '/account/pod-us-bill-order',
          meta: {
            title: 'POD(US)对账单',
          },
          component: PodUsBillOrder,
        },
        {
          path: '/typesetting-management/list',
          meta: {
            title: '打版管理',
          },
          component: TypeseetingManagement,
        },
        {
          path: '/logistics/logisticsMethod',
          meta: {
            title: '物流方式',
          },
          component: () => import('@/views/logistics/logisticsMethod.vue'),
        },
        {
          path: '/logistics/logisticsCompany',
          meta: {
            title: '物流公司',
          },
          component: () => import('@/views/logistics/logisticsCompany.vue'),
        },
        {
          path: '/logistics/shippingAddress',
          meta: {
            title: '发货地址',
          },
          component: () => import('@/views/logistics/shippingAddress.vue'),
        },
        {
          path: '/logistics/logisticsQuotation',
          meta: {
            title: '物流报价',
          },
          component: () => import('@/views/logistics/logisticsQuotation.vue'),
        },
        {
          path: '/logistics/declarationRule',
          meta: {
            title: '申报规则',
          },
          component: () => import('@/views/logistics/declarationRule.vue'),
        },
        {
          path: '/logistics/logisticsPartition',
          meta: {
            title: '物流分区',
          },
          component: () => import('@/views/logistics/logisticsPartition.vue'),
        },
        {
          path: '/logistics/logisticsCalculate',
          meta: {
            title: '运费试算',
          },
          component: () => import('@/views/logistics/logisticsCalculate.vue'),
        },
        {
          path: '/logistics/sortingConfiguration',
          meta: {
            title: '分拣配置',
          },
          component: () => import('@/views/logistics/sortingConfiguration.vue'),
        },
        {
          path: '/logistics/logisticsTracking',
          meta: {
            title: '物流跟踪',
          },
          component: () => import('@/views/logistics/logisticsTracking.vue'),
        },
        {
          path: '/warehouse/manage',
          meta: {
            title: '仓库管理',
          },
          component: WarehouseManage,
        },
        {
          path: '/warehouse/receipt-doc',
          meta: {
            title: '入库单',
          },
          component: receiptDoc,
        },
        {
          path: '/warehouse/issue-doc',
          meta: {
            title: '出库单',
          },
          component: issueDoc,
        },
        {
          path: '/warehouse/warning',
          meta: {
            title: '仓库预警',
          },
          component: WarehouseWarning,
        },
        {
          path: '/warehouse/position',
          meta: {
            title: '库位管理',
          },
          component: WarehousePosition,
        },
        {
          path: '/setting/settingIndex',
          meta: {
            title: '设置',
          },
          component: () => import('@/views/setting/settingIndex.vue'),
        },
        {
          path: '/MyDownloads',
          meta: {
            title: '我的下载',
          },
          name: 'MyDownloads',
          component: () => import('@/views/MyDownloads.vue'),
        },
      ],
    },
    // 登录
    {
      path: '/user/login',
      component: Login,
    },
    {
      path: '/user/reset',
      component: Reset,
    },

    // 其他路由
    {
      path: '/:pathMatch(.*)*',
      component: Error,
    },
  ],
})
router.beforeEach(
  (
    to: RouteLocationNormalized,
    _from: RouteLocationNormalized,
    next: NavigationGuardNext,
  ) => {
    const token = getToken()
    if (to.query.factoryCode) {
      localStorage.setItem('factory_code', String(to.query.factoryCode))
    }
    if (!token && to.path !== '/user/login') {
      next({ path: '/user/login' })
      return
    }
    next()
  },
)
export default router
