import { BasePaginationData, BaseRespData } from '@/types/api'
import axios from './axios'
import {
  LogListData,
  OrderData,
  QaData,
  SearchForm,
  SendOrderData,
  ShipmentForm,
  ShipmentOrderRes,
  Tab,
  InspectionData,
  PaymentForm,
  RejectParams
} from '@/types/api/order'
import {
  apiSubmitPodOrderForm,
  DeliveryNoteData,
  DeliveryNoteSearchForm,
  DetailForm,
  LogListsData,
  ProductionOrder,
  ShipmentOrderDetailData,
  updatePriceForm,
  IUpdatePrice,
} from '@/types/api/deliveryNote'
import {
  AccountStatementNote,
  AccountStatementNoteSearchForm,
  BillOrderDetailData,
  ConfirmOrderForm,
  CountStatus,
  LogList,
} from '@/types/api/billOrder'

export function getOrderList(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<OrderData>>(
    '/factory/customJomallOrder/list_page',
    { ...data, currentPage, pageSize },
  )
}

export function getOrderTabData() {
  return axios.get<never, BaseRespData<Tab[]>>(
    'factory/customJomallOrder/findStateGroupList',
  )
}

// 确认生产
export function confirmProductionOrder(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/confirmProduce',
    ids,
  )
}

// 下载稿件
export function downloadOrder(id: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/customJomallOrder/downloadMaterial',
    { params: { id } },
  )
}

// 重新生成稿件
export function reGenerateScriptUrlApi(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/downloadAgain',
    ids,
  )
}

export function reCreateScriptUrlApi(id: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/customJomallOrder/rebuildFileByOrderId',
    {
      params: {
        id,
      },
    },
  )
}
export function apiGetCraftGroup(id?: number | string) {
  return axios.get<never, BaseRespData<never>>(
    'pod/podReconciliation/getCraftGroup',
    {
      params: {
        id,
      },
    },
  )
}
// 打印生产单
export function printOrder(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/printProducePdf',
    ids,
  )
}

// 导出生产单
export function exportOrder(data?: { ids: number[]; status: string | number }) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/exportData',
    data,
  )
}

// 获取订单详情
export function getOrderBySubOrderNumber(orderNumber: string) {
  return axios.get<never, BaseRespData<OrderData>>(
    'factory/customJomallOrder/getOrderBySubOrderNumber',
    {
      params: {
        subOrderNumber: orderNumber,
      },
    },
  )
}

export function getQaOrderBySubOrderNumber(
  orderNumber: string,
  shipmentUid?: string,
) {
  return axios.get<never, BaseRespData<QaData[]>>(
    'factory/customJomallOrder/inspectionQuery',
    {
      params: {
        subOrderNumber: orderNumber,
        shipmentUid: shipmentUid,
      },
    },
  )
}

// 质检完成
export function qaFinishedApi(data: InspectionData[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/inspection',
    data,
  )
}
export function apiSetCraftData({
  id,
  craftTotalPrice,
  recNumber,
  craftPriceList,
}: {
  id: number | undefined
  craftTotalPrice: number | undefined
  recNumber: string | undefined
  craftPriceList: IUpdatePrice[]
}) {
  return axios.post<never, BaseRespData<never>>(
    'pod/podReconciliation/setCraftData',
    {
      id,
      recNumber,
      craftTotalPrice,
      craftPriceList,
    },
  )
}
// 发货保存
export function saveOrder(
  sumbitSendOutList: ShipmentOrderRes[],
  from: ShipmentForm,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/sendOut',
    { sumbitSendOutList, ...from },
  )
}

// 添加内部便签
export function addInternalTagApi(idList: number[], memo: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/batchAddInternalMemo',
    { idList, content: memo },
  )
}

// 查看发货单
export function loadSendOutList(id: number) {
  return axios.get<never, BaseRespData<SendOrderData[]>>(
    'factory/customJomallOrder/getShipmentListByCustomOrderId',
    {
      params: {
        id,
      },
    },
  )
}
// 设置备注
export function backEndCommentsApi(id: number, remark: string) {
  return axios.get<never, BaseRespData<SendOrderData[]>>(
    'factory/customJomallOrderProduct/setRemark',
    {
      params: {
        id,
        remark,
      },
    },
  )
}
//重新生成
export function regenerateSingle(subNumber: string | number) {
  return axios.get<never, BaseRespData<SendOrderData[]>>(
    'productionFile/regenerateSingle',
    {
      params: {
        subNumber,
      },
    },
  )
}
// 操作日志
export function getLogList(id: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    'factory/customJomallOrder/getLog',
    {
      params: {
        id,
      },
    },
  )
}

// 根据id获取数据详情
export function getOrderDetail(id: number) {
  return axios.get<never, BaseRespData<OrderData>>(
    'factory/customJomallOrder/getOrderById',
    {
      params: {
        id,
      },
    },
  )
}

// 取消
export function cancelOrderApi(id: number) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/cancel',
    { id },
  )
}

export function refreshProductInfo(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallOrder/refreshProductInfo',
    data,
  )
}
export function getDeliveryNoteList(
  data: DeliveryNoteSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<DeliveryNoteData>>(
    'factory/customJomallShipment/list_page',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}

export function customJomallReconciliation(
  data: AccountStatementNoteSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<AccountStatementNote>>(
    'reconciliation/list',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}

export function podReconciliationList(
  data: AccountStatementNoteSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<AccountStatementNote>>(
    'pod/podReconciliation/list',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}

export function printDeliveryNote(data: string[], userMark?: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallShipment/printInvoiceStatistics',
    {
      startTime: data && data[0],
      userMark,
      endTime: data && data[1],
    },
  )
}

export function createReconciliation(data: { shipmentIdList: number[] }) {
  return axios.post<never, BaseRespData<never>>(
    'factory/customJomallReconciliation/createReconciliation',
    data,
  )
}

export function getProductionOrderList(subOrderNumber: string) {
  return axios.get<never, BaseRespData<ProductionOrder>>(
    'customJomallOrderProduct/getBySubOrderNumber',
    {
      params: {
        subOrderNumber,
      },
    },
  )
}

export function getOrderByIdApi(id?: number) {
  return axios.get<never, BaseRespData<OrderData>>(
    'factory/customJomallOrder/getOrderById',
    {
      params: {
        id,
      },
    },
  )
}

export function getReconciliationAmount(id?: number) {
  return axios.get<never, BaseRespData<CountStatus[]>>(
    'reconciliation/groupCount',
    {
      params: {
        id,
      },
    },
  )
}

export function podReconciliation(id?: number) {
  return axios.get<never, BaseRespData<CountStatus[]>>(
    'pod/podReconciliation/groupCount',
    {
      params: {
        id,
      },
    },
  )
}

export function getCustomJomallReconciliationById(id?: number) {
  return axios.get<never, BaseRespData<OrderData>>(
    'factory/customJomallReconciliation/getById',
    {
      params: {
        id,
      },
    },
  )
}

export function customJomallReconciliationLog(reconciliationId?: number) {
  return axios.get<never, BaseRespData<OrderData>>(
    'factory/customJomallReconciliationLog/getListById',
    {
      params: {
        reconciliationId,
      },
    },
  )
}

export function updateReconciliation(data: AccountStatementNote) {
  return axios.post(
    'factory/customJomallReconciliation/updateReconciliation',
    data,
  )
}
export function exportExcelApi(ids: string) {
  return axios.get<never, BaseRespData<never>>('reconciliation/exportExcel', {
    params: {
      ids,
    },
  })
}
export function exportPodExcelApi(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    'pod/podReconciliation/exportExcel',
    {
      params: {
        ids,
      },
    },
  )
}
export function getShipmentDetailsById(data: DetailForm) {
  return axios.post<never, BasePaginationData<BillOrderDetailData>>(
    'reconciliation/getItemList',
    data,
  )
}
export function apiupdateByPodExcel(formData: never) {
  return axios.post('pod/podReconciliation/updateByExcel', formData, {
    headers: {
      'Content-Type': 'multipart/form-data',
    },
  })
}
export function apiRejectedPodReconciliation(params?: RejectParams) {
  return axios.post<never, BaseRespData<never>>(
    'pod/podReconciliation/rejectedLocal',
    params,
  )
}
export function getPodShipmentDetailsById(data: DetailForm) {
  return axios.post<never, BasePaginationData<BillOrderDetailData>>(
    'pod/podReconciliation/getItemList',
    data,
  )
}
export function apiLogList(id?: number) {
  return axios.get<never, BaseRespData<LogListsData[]>>(
    'pod/podReconciliation/getLog',
    { params: { id } },
  )
}

export function apiItemLogList(id?: number) {
  return axios.get<never, BaseRespData<LogListsData[]>>(
    'pod/podReconciliation/getItemLog',
    { params: { id } },
  )
}

export function apiSubmitPodOrder(params: apiSubmitPodOrderForm) {
  return axios.get<never, BaseRespData<ShipmentOrderDetailData>>(
    'pod/podReconciliation/create',
    { params },
  )
}

export function apiPodBillSubmit(ids: number[]) {
  return axios.post<never, BaseRespData<ShipmentOrderDetailData>>(
    'pod/podReconciliation/submission',
    { ids },
  )
}

export function apiPodUpdatePrice(data: updatePriceForm) {
  return axios.get<never, BaseRespData<never>>(
    'pod/podReconciliation/updatePrice',
    { params: data },
  )
}

export function updateRecPrice(data: updatePriceForm) {
  return axios.get<never, BaseRespData<never>>(
    'pod/podReconciliation/updateRecPrice',
    { params: data },
  )
}

export function getLogListApi(id?: number) {
  return axios.get<never, BaseRespData<LogList[]>>('reconciliation/getLog', {
    params: { id },
  })
}

export function getPodLogListApi(id?: number) {
  return axios.get<never, BaseRespData<LogList[]>>(
    'pod/podReconciliation/getLog',
    {
      params: { id },
    },
  )
}
export function auditOrderApi(url: string, data: string) {
  return axios.get(url, {
    params: {
      ids: data,
    },
  })
}
export function getShipmentOrderDetailById(id?: number | string) {
  return axios.get<never, BaseRespData<ShipmentOrderDetailData>>(
    'reconciliation/getShipmentByShipmentId',
    {
      params: {
        id,
      },
    },
  )
}

export function confirmOrderApi(data: ConfirmOrderForm) {
  return axios.post<never, BaseRespData<never>>('reconciliation/confirm', data)
}

export function confirmPodOrderApi(data: ConfirmOrderForm) {
  return axios.post<never, BaseRespData<never>>(
    'pod/podReconciliation/confirm',
    data,
  )
}
export function apiRejectionOfReview({
  ids,
  description,
  recNumbers,
}: {
  ids: string
  recNumbers: string
  description: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'pod/podReconciliation/rejectionOfReview',
    {
      ids,
      description,
      recNumbers,
    },
  )
}
export function apiBillPodPayment(data: PaymentForm) {
  return axios.post<never, BaseRespData<never>>(
    'pod/podReconciliation/payment',
    data,
  )
}
export function rejectOrderApi({
  ids,
  description,
  pass,
}: {
  ids: string
  pass: number
  description: string
}) {
  return axios.post<never, BaseRespData<never>>('reconciliation/confirm', {
    ids,
    description,
    pass,
  })
}
