export type AnyObject = {
  [propName: string]: string | number | boolean | undefined | unknown
}
export interface warehouseSearchForm {
  billStatus?: string
  createTimeEnd?: string
  createTimeStart?: string
  startTime?: string
  endTime?: string
  inNo?: string
  outNo?: string
  warehouseSku?: string
  warehouseId?: number | string
  id?: number
}
export interface InterProductList {
  createTime?: string
  id?: number
  inventoryId?: number | null
  inId?: number
  productNo?: string | null //custom的货号
  buyStored?: number | null //入库数量
  outCount?: number | null //出库数量
  remark?: string | null
  skuImage?: string
  skuName?: string
  costPrice?: number | null
  totalPrice?: number | null
  updateTime?: string
  warehouseSku?: string
  locationId?: number | null
  locationCode?: string | null
  [propName: string]: string | number | boolean | undefined | unknown
}
export interface InterWarehouseBase {
  id?: number
  factoryId?: number
  factoryCode?: string
  warehouseId?: number | string
  warehouseName?: string | null
  inNo?: string
  outNo?: string
  shipmentNumber?: string
  skuAmount?: number
  total?: number
  totalPrice?: number
  billStatus?: string
  billStatusTxt?: string
  remark?: string | null
  dataVersion?: number
  createTime?: string | null
  updateTime?: string | null
  rejectReason?: string | null
  number?: number | string | null
  supplierItemNo?: string | null
}
// 主表列表ts
export interface InterWarehousePage extends InterWarehouseBase { }
// 子表列表ts
export interface InterWarehouseDetail extends InterWarehouseBase {
  productList: InterProductList[]
}
export interface ExportInWarehouseInfo extends warehouseSearchForm {
  total?: number
  idList?: string | number[]
  showDetail?: boolean
}
export interface InterWarehouseTree {
  id?: number
  code?: string | null
  name?: string
  countQuantity?: string | null
  children: InterWarehouseTree[] | null
  leaf?: boolean
}
export interface InterProductList {
  createTime?: string
  id?: number
  inId?: number
  productNo?: string | null //货号
  buyStored?: number | null //入库数量
  outCount?: number | null //出库数量
  usableInventory?: number | null //可用库存数量
  remark?: string | null
  skuImage?: string
  skuName?: string
  costPrice?: number | null
  totalPrice?: number | null
  updateTime?: string
  warehouseSku?: string
  locationId?: number | null
  locationCode?: string | null
  inventory?: {
    usableInventory?: number
  }
}
export interface InterskuList {
  id?: number
  productId?: number
  sku?: string
  skuName?: string
  image?: string
  factoryPrice?: number | null
  productNo?: string | null //货号
  productNumber?: string | null //出库单货号
  locationId?: number | null
  locationCode?: string | null
  price?: number | null //出库单的
  usableInventory?: number | null
  warehouseSku?: string
  remark?: string | null
  currencyName?: string | null
  currencyCode?: string | null
}
export interface ILocation {
  id?: number
  locationId?: number | null
  locationCode?: string | null
}

export interface stockingPlanSearchForm {
  warehouseId?: number | string
  warehouseSku?: string
  outNo?: string
  timeType?: string
  startTime?: string
  endTime?: string
}
