export interface DeliveryNoteSearchForm {
  subOrderNumber?: string
  billNumber?: number
  userMark?: string
  startTime?: string
  endTime?: string
  logisticsTracking?: string
  lanshouName?: string
  orderNumber?: string
  namespace?: string
  shippingWay?: number
  status?: number | null
}

export interface IUpdatePrice {
  process: string
  base_price: string | number
  add_price: string | number
}
export interface DeliveryNoteData {
  id: number
  billNumber?: string
  shippingWay?: number
  addressId?: number
  carriageAmount?: number | string
  carriageName?: string
  logisticsTracking?: string
  shippingStatus?: number
  lanshouName?: string
  lanshouPhone?: string
  lanshouRegion?: string
  lanshouAddress?: string
  lanshouPost?: string
  inspectionStatus?: boolean
  facotoryNo?: number
  updateTime?: string
  createTime?: string
  subOrderNumber?: string
  detailList: DetailList[]
}

export interface DetailList {
  id: number
  shipmentId?: number
  customOrderId?: number
  customOrderNumber?: string
  subOrderNumber?: string
  baseSku?: string
  variantSku?: string
  variantImage?: string
  shipmentNum?: number
  passNum?: number
  notPassNum?: number
  inspectionStatus?: boolean
  updateTime?: string
  createTime?: string
  productionNum?: number
  notShipmentNum?: number
  productName?: string
  facotoryNo?: string | number
  billNumber?: string | number
}

export interface NameSpaceList {
  id: number
  sku?: string
  name?: string
  password?: string
  imgUrl?: string
  chimaStatus?: number
  status?: number
  createDate?: string
  updateDate?: string
}

export interface ProductionOrder {
  id: number
  erpId?: number
  customOrderId?: number
  subOrderNumber?: string
  erpSubOrderNumber?: string
  erpOrderId?: number
  erpOrderItemId?: number
  erpProductItemId?: number
  shopNumber?: number
  baseSku?: string
  variantSku?: string
  variantImage?: string
  chimaId?: string
  diyId?: string
  endProductId?: string
  num?: number
  printType?: number
  version?: number
  shipmentNum?: number
  price?: number
  productName?: string
  weight?: number
  createTime?: string
  updateTime?: string
  notPassNum?: number
  passNum?: number
}
export interface ShipmentOrderDetailData {
  carriage_amount?: string | number
  lanshou_post?: string
  carriage_name?: string
  create_time?: string
  order_number?: string
  lanshou_address?: string
  logistics_tracking?: string
  update_time?: string
  bill_number?: string
  lanshou_region?: string
  user_mark?: string
  detailList?: ShipmentDetailList[]
  lanshou_phone?: string
  id: string | number
  shipping_way?: number
  dbFactory?: DbFactory
  lanshou_name?: string
  inspection_status?: boolean
  facotory_no?: number
}

export interface ShipmentDetailList {
  product?: Product
  create_time?: string
  variant_image?: string
  base_sku?: string
  pass_num?: number
  sub_order_number?: string
  shipment_id?: string
  custom_order_id?: string
  custom_order_number?: string
  not_pass_num?: number
  update_time?: string
  variant_sku?: string
  id: number | string
  shipment_num?: number
  inspection_status?: boolean
}

export interface Product {
  diy_id?: string
  end_product_id?: string
  base_sku?: string
  num?: number
  sub_order_number?: string
  print_type?: number
  custom_order_id?: string
  erp_order_id?: string
  erp_sub_order_number?: string
  update_time?: string
  erp_order_item_id?: string
  price?: number
  id: string
  shipment_num?: number
  cost_price?: string | number
  erp_product_item_id?: number
  erp_id?: string
  create_time?: string
  variant_image?: string
  pass_num?: number
  weight?: string | number
  not_pass_num?: number
  product_name?: string
  version?: number
  chima_id?: string
  material?: string
  variant_sku?: string
  shop_number?: string
  sales_price?: string | number
}

export interface DbFactory {
  license?: string | number
  goods_number?: number
  type_id?: number
  bianma?: string
  name?: string
  mobile?: string
  ruzhu_date?: string
  id: number
  title?: string
  create_date?: string
  authorize_number?: number
  status?: number
}

export interface IDetailData {
  statusStr?: string;
  id: string;
  erp_id?: string;
  namespace?: string;
  dbFactory?: DbFactory | null;
  factory?: DbFactory | null;
  productList?: Product[];
  order_number?: string;
  factory_order_number?: string;
  erp_order_number?: string;
  third_order_number?: string;
  shop_number?: string;
  product_num?: string | number;
  start_stocking_time?: string;
  finish_time?: string;
  delivery_type?: string;
  logistics_way_name?: string;
  lanshou_name?: string;
  receiver_name?: string;
  lanshou_phone?: string;
  receiver_phone?: string;
  lanshou_region?: string;
  receiver_province?: string;
  lanshou_address?: string;
  receiver_city?: string;
  receiver_district?: string;
  receiver_address1?: string;
  lanshou_post?: string;
  receiver_post_code?: string;
  user_mark?: string;
  price?: number
  customized_quantityStr?: string
  product_price?:string
  customized_quantity:number
  image_ary?:string | null
  [propName: string]: string | number | boolean | undefined | unknown;
}

export interface PodUsDetailData {
  id: number
  erp_id?: string;
  price?: number;
  customized_quantityStr?: string;
  product_price?: number;
  // 其他已有属性...
  customized_quantity: number; // 添加缺失属性
  image_ary?: string | null;    // 添加缺失属性
  productList:IDetailData[]
  [propName: string]: string | number | boolean | undefined | unknown;
}
export interface LogListsData {
  id: number
  diy_id: number
  employee_account?: string
  employee_name?: string
  employee_id?: string
  description?: string
  create_time?: string
}
export interface LogListData {
  id?: string | number | null
  infoId?: number
  employeeId?: number
  employeeAccount?: string
  description?: string
  createTime?: string
  create_time?: string
  employee_account?: string
}
export interface DetailForm {
  billNumber?: string
  orderNumber?: string
  craftCode?: string
  baseSku?: string
  shipmentNumber?: string
  process?: string
  supplierItemNo?: string
  dateRange?: string[]
  endTime?: string
  startTime?: string
  subOrderNumber?: string
  rows?: number
  page?: number
  currentPage?: number
  pageSize?: number
  infoId?: number
}
export interface BillForm {
  timeRange: [string, string] | []
}

export interface apiSubmitPodOrderForm {
  startDate?: string
  endDate?: string
}
export interface updatePriceForm {
  ids?: string
  infoId?: number
  price?: string
}
