export interface CountStatus {
  id?: number
  code?: number
  count?: number
  remark?: string
  children?: CountStatus[]
}
export interface AccountStatementNoteSearchForm {
  user_mark?: string
  status?: number | string | null
  dateRange?: string[]
  billNumber?: string
  subOrderNumber?: string
  shipmentNumber?: string
  recNumber?: string
  orderNumber?: string
  factory_status?: string
  erp_status?: string
  startTime?: string
  start_time?: string
  endTime?: string
  end_time?: string
}

export interface AccountStatementNote {
  create_time?: string
  product_total_amount?: number
  craft_total_amount?: number
  pass_num?: number
  factory_code?: string
  total_amount?: string | number
  actual_amount?: string | number
  num?: number
  end_time?: string
  rec_number?: string
  not_pass_num?: number
  factory_id?: number
  start_time?: string
  carriage_total_amount?: number
  factory_status?: number
  factory_total_amount?: number
  user_mark?: string
  erp_status?: number
  id?: number
  erp_total_amount?: number
  dataVersion: ''
  water_list?: {
    url: string | undefined
  }[]
}
export interface BillOrderDetailData {
  create_time?: string
  pass_num: number
  factory_code?: string
  num?: number
  end_time?: string
  rec_number?: string
  not_pass_num?: number
  factory_id?: number
  start_time?: string
  carriage_total_amount?: number
  factory_status?: number
  factory_total_amount: number
  user_mark?: string
  logList?: LogList[]
  erp_status?: number
  itemList?: ItemList[]
  id: number
  erp_total_amount?: number
}

export interface LogList {
  create_time?: string
  info_id?: number
  id: string
  diy_id: number
  employee_account?: string
  employee_name?: string
  employee_id?: string
  description?: string
}

export interface ItemList {
  carriage_amount?: number
  pass_num?: number
  num?: number
  factory_price?: number
  shipment_id?: string
  not_pass_num?: number
  erp_order_number?: string
  shipment_time?: string
  bill_number?: string
  erp_price?: number
  info_id?: number
  id: number
  factory_order_number?: string
}

export interface ConfirmOrderForm {
  pass?: number | null
  description?: string
  ids?: string
}
