import { BasePaginationData, BaseRespData } from '@/types/api'
import axios from './axios'
import {
  SearchForm,
  Tab,
  ShipmentOrderRes,
  PodDeliveryNoteSearchForm,
  DeliveryNoteData,
  LogListData,
} from '@/types/api/podOrder'
import { OrderData, ShipmentForm } from '@/types/api/order'
import { PodProductList } from '@/types/api/podOrder'

export function getOrderTabData() {
  return axios.get<never, BaseRespData<Tab[]>>(
    'factory/podJomallOrder/findStateGroupList',
  )
}
export function getOrderDetail(id: number) {
  return axios.get<never, BaseRespData<PodProductList>>(
    'factory/podJomallOrderProduct/getSubOrderById',
    {
      params: {
        id,
      },
    },
  )
}
export function getSubOrderBySubOrderNumber(thirdSubOrderNumber: string) {
  return axios.get<never, BaseRespData<PodProductList>>(
    'factory/podJomallOrderProduct/getSubOrderByThirdSubOrderNumber',
    {
      params: {
        thirdSubOrderNumber,
      },
    },
  )
}
export function refreshJMProductInfo(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/refreshJomallPodProduct ',
    data,
  )
}
export function getOrderList(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<OrderData>>(
    '/factory/podJomallOrder/list_page',
    { ...data, currentPage, pageSize },
  )
}
// 快捷生产完成
export function productionQueryApi(id: number) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderProduct/completeDelivery',
    {
      id,
    },
  )
}
export function getCardOrderList(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<PodProductList>>(
    '/factory/podJomallOrder/getSubListPage',
    { ...data, currentPage, pageSize },
  )
}
export function getOrderBySubOrderNumber(orderNumber: string) {
  return axios.get<never, BaseRespData<OrderData>>(
    // 'factory/podJomallOrder/getOrderBySubOrderNumber',
    'factory/podJomallOrder/getOrderProductByThirdSubOrderNumber',
    {
      params: {
        thirdSubOrderNumber: orderNumber,
      },
    },
  )
}
export function applyForReplenishmentApi(data: unknown) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProduct/applyForReplenishment',
    data,
  )
}
export function syncSubOrderDesignImages(data: unknown) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProduct/syncSubOrderDesignImages',
    data,
  )
}
// 发货保存
export function saveOrder(
  sumbitSendOutList: ShipmentOrderRes[],
  from: ShipmentForm,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/sendOut',
    { sumbitSendOutList, ...from },
  )
}
// 确认生产
export function confirmProductionOrder(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/confirmProduce',
    ids,
  )
}
// 确认生产
export function confirmProduct(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/confirmProduct',
    ids,
  )
}
// 取消
export function cancelOrderApi(id: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrder/cancel',
    { params: { id } },
  )
}
// 下载素材

export function downloadMaterialApi(id: Array<number>) {
  return axios.post<never, BaseRespData<Array<string>>>(
    'factory/podJomallOrder/downloadByProduction',
    id,
  )
}
// 添加内部便签
export function addInternalTagApi(idList: number[], memo: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/batchAddInternalMemo',
    { idList, content: memo },
  )
}
export function reasonInvalidationApi(idList: number[], memo: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/invalidSubOrder',
    { idList, reasonStr: memo },
  )
}
// 打印生产单
export function printOrder(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/printProducePdf',
    ids,
  )
}
export function exportOrder(ids: number[], status: string | number) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/exportData',
    { ids: ids, status },
  )
}
// 发货单
export function getDeliveryNoteList(
  data: PodDeliveryNoteSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<DeliveryNoteData>>(
    'factory/podJomallShipment/list_page',
    { ...data, currentPage, pageSize },
  )
}
// 操作日志
export function getLogList(id: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    'factory/logPodJomallOrder/getLogByOrderId',
    {
      params: {
        id,
      },
    },
  )
}
export function printDeliveryNote(data: string[], userMark?: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallShipment/printInvoiceStatistics',
    {
      startTime: data && data[0],
      userMark,
      endTime: data && data[1],
    },
  )
}

export function getPodJomallOrderByFactoryNumber(factoryOrderNumber: string) {
  return axios.get<never, BaseRespData<OrderData>>(
    'factory/podJomallOrder/getPodJomallOrderByFactoryNumber',
    {
      params: {
        factoryOrderNumber,
      },
    },
  )
}
export function updateRemarkApi(id: number, remark: string) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrder/setRemark',
    {
      params: {
        productId: id,
        remark,
      },
    },
  )
}
export function getInProductionCount(
  productionFileId: unknown,
  baseSku: unknown,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProduct/getInProductionCount',
    {
      productionFileId,
      baseSku,
    },
  )
}
export function getWaitShipmentCount(
  productionFileId: unknown,
  baseSku: unknown,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProduct/getWaitShipmentCount',
    {
      productionFileId,
      baseSku,
    },
  )
}
// 完成发货
export function completeDeliveryApi(
  productIdList: number[],
  data: ShipmentForm,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/completeDelivery ',
    { productIdList, ...data },
  )
}
export function exportStatementApi(data: SearchForm, status: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrder/exportPodJomallReconciliation',
    { ...data, status },
  )
}
