interface ResizeObserverElement extends HTMLElement {
  __resizeListeners__?: ((entry: ResizeObserverEntry) => void)[]
  __ro__?: ResizeObserver
}

// copy from element-ui
const resizeHandler = function (entries: ResizeObserverEntry[]) {
  for (const entry of entries) {
    const listeners =
      (entry.target as ResizeObserverElement).__resizeListeners__ || []
    if (listeners.length) {
      listeners.forEach((fn) => {
        fn(entry)
      })
    }
  }
}
// copy from element-ui
export const addResizeListener = function (
  element: ResizeObserverElement,
  fn: (entry: ResizeObserverEntry) => void,
) {
  if (!element.__resizeListeners__) {
    element.__resizeListeners__ = []
    element.__ro__ = new ResizeObserver(resizeHandler)
    element.__ro__.observe(element)
  }
  element.__resizeListeners__.push(fn)
}

// copy from element-ui
export const removeResizeListener = function (
  element: ResizeObserverElement,
  fn: () => void,
) {
  if (!element || !element.__resizeListeners__) return
  element.__resizeListeners__.splice(element.__resizeListeners__.indexOf(fn), 1)
  if (!element.__resizeListeners__.length) {
    element.__ro__?.disconnect()
  }
}

type DOMClass =
  | string
  | string[]
  | Record<string, number | string | boolean | undefined | null>
  | undefined

export function normalizeClasses(cls: DOMClass) {
  if (typeof cls === 'string') return cls
  else if (Array.isArray(cls)) return cls.join(' ')
  else if (typeof cls === 'object') {
    let classes = ''
    for (const key in cls) {
      if (cls[key]) classes += cls + ' '
    }
    return classes.trim()
  }
  return ''
}

export function concatClasses(cls: DOMClass, ...classes: DOMClass[]) {
  return (
    normalizeClasses(cls) +
    ' ' +
    classes.map(normalizeClasses).join(' ')
  ).trim()
}
