import type { Column as ElColumn } from 'element-plus/lib/components/index.js'

interface Column<D> extends Omit<ElColumn, 'width'> {
  width?: number | string
  minWidth?: number | string
  key?: string
  slot?: string
  headerSlot?: string
  headerRender?: (scope: { column: never; index: number }) => JSX.Element
  render?: (scope: { row: D; index: number }) => JSX.Element
  formatDate?: (row: D) => string
  children?: Column<D>[]
  subs?: Column<D>[]
  buttons?: {
    text: string
    type?: 'primary' | 'success' | 'warning' | 'danger' | 'info'
    onClick: (row: D) => void
    show?: (row: D) => boolean
  }[]
}

export interface TableProps<T> {
  data: T[]
  columns: Column<T>[]
  stripe?: boolean
  border?: boolean
  height?: string | number
  maxHeight?: string | number
  showPagination?: boolean
  pageSize?: number
  currentPage?: number
  total?: number
  loading?: boolean
  rowKey?: string | ((row: T) => string)
  selectable?: boolean
  selectedRows?: T[]
}

export type CustomColumn<D> = Column<D>
