import { BasePaginationData, BaseRespData } from '@/types/api'
import axios from './axios'
import { ExternalAuthListData } from '@/types/api/externalAuth'
export function getExternalAuthorisationListApi(
  data?: {
    type?: string
  },
  page?: number,
  pageSize?: number,
) {
  return axios.post<never, BasePaginationData<ExternalAuthListData>>(
    'factory/baseExternalAccount/list_page',
    null,
    {
      params: {
        ...data,
        currentPage: page,
        pageSize,
      },
    },
  )
}

export function loadAccountTypesApi() {
  return axios.get<never, BaseRespData<string[]>>(
    'factory/baseExternalAccount/allCodelist',
  )
}
export function getExternalAuthorisationByIdApi(id?: number | null) {
  return axios.get<never, BaseRespData<ExternalAuthListData>>(
    `factory/baseExternalAccount/get?id=${id}`,
  )
}
export function deleteExternalAuthorisationApi(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    `factory/baseExternalAccount/delete?ids=${ids}`,
  )
}
export function baseExternalAccountLogsApi(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/baseExternalAccount/logs`,
    { params },
  )
}
export function addExternalAuthorisationApi(
  url: string,
  data: ExternalAuthListData,
) {
  return axios.post<never, BaseRespData<never>>(url, data)
}
export function saveInventoryLowerLimitApi(inventoryLowerLimit: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/baseExternalAccount/setInventoryWarningFloor',
    { params: { inventoryWarningFloor: inventoryLowerLimit } },
  )
}
export function getInventoryLowerLimitApi() {
  return axios.get<never, BaseRespData<number>>(
    'factory/baseExternalAccount/getInventoryWarningFloor',
  )
}
