# vxeTable(待优化)

## Table 属性 (Props)

|      参数       |                   说明                    |     类型      | 默认值 |
| :-------------: | :---------------------------------------: | :-----------: | :----: |
|     config      |                表格列配置                 | TableColumn[] |   []   |
| tableEditConfig |               表格编辑配置                |    Object     |   {}   |
|   modelValue    |                 表格数据                  |   Object[]    |   []   |
|  getTablelist   |               数据加载方法                |   Function    |  null  |
| isShowCheckBox  |              是否显示复选框               |    Boolean    |  true  |
|       ...       | 其余属性与 vxetable 文档中 api Props 相同 |      ...      |  ...   |

- **Table 表格说明**:
- table 表格如需动态渲染则需要传入计算属性 config
- Table 属性 (Props) 可自行添加,添加属性与 vxetable 文档中 api Props 相同
- 可参考文件 src\views\logistics\logisticsMethod.vue

```tsx **config 示例**
const config = [
  {
    prop: 'name',
    label: '姓名',
    attrs: {
      width: 120,
      align: 'center',
      fixed: 'left',
      resizable: false,
      className: 'status-column',
    },
  },
  {
    prop: 'status',
    label: '状态',
    render: {
      default: ({ row }) => (
        <Tag color={row.status === 1 ? 'success' : 'error'}>
          {row.status === 1 ? '正常' : '禁用'}
        </Tag>
      ),
      edit: ({ row }) => (
        <Select v-model={row.status}>
          <Option value={1}>正常</Option>
          <Option value={0}>禁用</Option>
        </Select>
      ),
    },
  },
]
```

---

## TableColumn 结构

|  参数  |      说明      |      类型       |
| :----: | :------------: | :-------------: |
|  prop  |    列字段名    |     string      |
| label  |     列标题     |     string      |
| attrs  |    额外属性    |  ColumnAttrs()  |
| render | 自定义渲染函数 | RenderFunctions |

- **TableColumn 表格说明**:
- attrs 中属性与 vxetable 文档中 Column Props 相同
- RenderFunctions 默认使用 default，如要开启单元格编辑 edit 需在 Table 中传入 tableEditConfig.enabled=true

```ts
interface ColumnAttrs {
  width?: string | number
  [key: string]: unknown
}
interface RenderFunctions {
  // 默认单元格渲染
  default?: (params: { row: TableRowData }) => VNode | VNode[] | JSX.Element
  // 编辑状态渲染
  edit?: (params: { row: TableRowData }) => VNode | VNode[] | JSX.Element
  // 其他自定义渲染
  [key: string]:
    | ((params: { row: TableRowData }) => VNode | VNode[] | JSX.Element)
    | undefined
}
```

---

## 事件 (Events)

|       事件名       |      说明      |           回调参数           |
| :----------------: | :------------: | :--------------------------: |
| update:modelValue  |  表格数据变化  |         表格数据数组         |
|  checkbox-change   | 复选框选择变化 |        当前选中行数据        |
| getCheckboxRecords | 获取选中行数据 | 当前选中行数据（含全选状态） |

---

## 可用方法

|     方法名     |      说明      |   参数   |
| :------------: | :------------: | :------: |
| getSelectEvent | 获取选中行数据 |    无    |
| selectRowEvent |   设置高亮行   | row: any |

- **说明**: 可新增方法自行添加
