import { BasePaginationData, BaseRespData } from '@/types/api'
import axios from './axios'
import {
  LogisticsMethod,
  LogisticsMethodList,
  UpdateLogisticsMethodStatus,
} from '@/views/logistics/types/logistics'
import { AddDeclarationRuleObj } from '@/views/logistics/types/declarationRule'
import { LogisticsQuotation } from '@/views/logistics/types/logisticsQuotation'
import { LogisticsPartitionObj } from '@/views/logistics/types/logisticsPartition'
import { ShippingAddressObj } from '@/views/logistics/types/shippingAddress'
import { IsortingInfo } from '@/types/api/logistics'
export interface ILogisticsList {
  code: string
  basicsName: string
  apiData: unknown
}
export interface IForm {
  name: string
  code: string
  id?: number
  contact: string
  phone: string
  siteUrl: string
  address: string
  apiData: {
    [key: string]: unknown
  }
}
interface Ikey {
  [key: string]: unknown
}

export interface ILogisticsCompanyData {
  pageSize: number
  currentPage: number
  total?: number
  name?: string
  code?: string
}

export interface ILogisticsCompany {
  id: number // bigint(20)
  name: string | null // varchar(255)
  code: string // varchar(30)
  contact: string | null // varchar(255)
  phone: string | null // varchar(100)
  apiJson: string | null // varchar(600)
  mobile: string | null // varchar(60)
  carrier: string | null // varchar(6)
  address: string | null // varchar(255)
  siteUrl: string | null // varchar(255)
  apiKey: string | null // varchar(256)
  apiToken: string | null // varchar(256)
  clientId: string | null // varchar(256)
  accessToken: string | null // varchar(256)
  accessTokenExpiresIn: number | null // int(11)
  refreshToken: string | null // varchar(256)
  refreshDate: string | null // datetime
  refreshTokenExpiresIn: number | null // int(11)
  authCode: string | null // varchar(500)
  redirectUri: string | null // varchar(256)
  createTime: string | null // timestamp
  vat: string | null // varchar(60)
  ioss: string | null // varchar(60)
  basicType: number // int(11)
}

interface ILogisticsParams {
  logType: string
  relaId: number | string
}

//获取日志
export function getLogisticsLog(params: ILogisticsParams) {
  return axios.get<never, BaseRespData<never>>('logisticsLog/getList', {
    params,
  })
}

/**
 * @description 物流方式
 */
//列表
export function getLogisticsWayList(data: LogisticsMethodList) {
  return axios.post<never, BaseRespData<never>>('/logisticsWay/list_page', data)
}

//新增
export function addLogisticsWay(data: LogisticsMethod) {
  return axios.post<Ikey, BaseRespData<never>>('/logisticsWay/add', data)
}

//修改
export function updateLogisticsWay(data: LogisticsMethod) {
  return axios.post<Ikey, BaseRespData<never>>('/logisticsWay/update', data)
}

//更新状态
export function updateStatusLogisticsWay(params: UpdateLogisticsMethodStatus) {
  return axios.get<Ikey, BaseRespData<never>>(
    '/logisticsWay/updateStatusById',
    {
      params,
    },
  )
}

// 删除
export function deleteLogisticsWay(ids: string) {
  return axios.get<Ikey, BaseRespData<never>>('/logisticsWay/delete', {
    params: { ids: ids },
  })
}

//获取申报规则列表
export function getRuleList() {
  return axios.get<never, BaseRespData<never>>(
    '/logisticsCustomsRule/getRuleList',
  )
}

//获取仓库列表
export function getWarehouseList() {
  return axios.get<never, BaseRespData<never>>('/factoryWarehouseInfo/getAll')
}

//获取平台列表
export function getPlatformList() {
  return axios.get<never, BaseRespData<never>>('/logisticsWay/platform')
}
//获取物流公司列表
export function getLogisticsCompanyList() {
  return axios.get<never, BaseRespData<never>>('/logisticsCompany/all_options')
}
//获取物流公司列表
export function getUniuniList() {
  return axios.get<never, BaseRespData<never>>(
    '/logistics/logisticsUinuinWarehouse/listByCountryCode',
    {
      params: {
        countryCode: 'US',
      },
    },
  )
}

/**
 * @description 发货地址
 */
//列表
export function getAddressByIdList(params: {
  pageSize?: number
  currentPage?: number
}) {
  return axios.get<never, BaseRespData<never>>('/logisticsAddress/list_page', {
    params,
  })
}

//根据id查询地址
export function getAddressById(params: { id: number | string }) {
  return axios.get<never, BaseRespData<never>>(
    '/logisticsAddress/getAddressById',
    {
      params,
    },
  )
}

//新增
export function addAddress(params: ShippingAddressObj) {
  return axios.post<never, BaseRespData<never>>(
    '/logisticsAddress/addAddress',
    params,
  )
}

//修改
export function updateAddress(params: ShippingAddressObj) {
  return axios.post<never, BaseRespData<never>>(
    '/logisticsAddress/updateAddress',
    params,
  )
}

//删除
export function deleteAddressByIds(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>(
    '/logisticsAddress/deleteAddressByIds',
    {
      params,
    },
  )
}
//获取国家名称及代码
export function getAllCountryApi() {
  return axios.get<never, BaseRespData<never>>(
    '/logisticsAddress/getAllCountry',
  )
}

/**
 * @description 物流报价
 */
//物流方式列表
export function getlogisticsWayAllList() {
  return axios.get<never, BaseRespData<never>>('/logisticsWay/all_list', {})
}

//物流报价列表
export function getlogisticsQuotationList(params: {
  logisticsIdList?: number[]
  pageSize: number
  currentPage: number
}) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/list_page',
    params,
  )
}
export function getlogisticsQuotationPage(params: {
  logisticsIdList?: number[]
  pageSize: number
  currentPage: number
}) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/page',
    params,
  )
}
//新增
export function addLogisticsQuotation(params: LogisticsQuotation) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/add',
    params,
  )
}

//修改
export function updateLogisticsQuotation(params: LogisticsQuotation) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/update',
    params,
  )
}

//删除
export function deleteLogisticsQuotation(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/delete',
    {
      params,
    },
  )
}

//导入
export function importLogisticsQuotation(formData: FormData) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/import',
    formData,
    {
      headers: {
        'Content-Type': 'multipart/form-data',
      },
    },
  )
}

//下载模版
export function downloadLogisticsQuotationTemplate() {
  return axios.get<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/exportExcel',
    {
      responseType: 'blob',
    },
  )
}

//根据ID查对象
export function getLogisticsQuotationByID(params: { id: number | string }) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/get',
    params,
  )
}

/**
 * @description 申报规则
 */
//列表
export function getLogisticsCustomsRuleList(params: {
  name?: string
  pageSize: number
  currentPage: number
}) {
  return axios.post<never, BaseRespData<never>>(
    '/logisticsCustomsRule/list_page',
    params,
  )
}

//物流方式列表
export function usableAllList() {
  return axios.get<never, BaseRespData<never>>('/logisticsWay/usableAllList')
}
//新增
export function addLogisticsCustomsRule(params: AddDeclarationRuleObj) {
  return axios.post<never, BaseRespData<never>>(
    '/logisticsCustomsRule/add',
    params,
  )
}

//修改
export function updateLogisticsCustomsRule(params: AddDeclarationRuleObj) {
  return axios.post<never, BaseRespData<never>>(
    '/logisticsCustomsRule/update',
    params,
  )
}

//删除
export function deleteLogisticsCustomsRule(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>('/logisticsCustomsRule/delete', {
    params,
  })
}

/**
 * @description 物流分区
 */
//列表
export function getLogisticsZoneList(params: {
  logisticsIdList?: string[] | string | number[] | number
  codePrefix?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsZone/list',
    params,
  )
}

//新增
export function addLogisticsZone(params: LogisticsPartitionObj) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsZone/add',
    params,
  )
}

//修改
export function updateLogisticsZone(params: LogisticsPartitionObj) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsZone/update',
    params,
  )
}

//删除
export function deleteLogisticsZone(params: {
  logisticsList: string[]
  zoneNameList: string[]
}) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsZone/delete',
    params,
  )
}

//物流分区导入
export function importLogisticsZone(formData: FormData) {
  return axios.post<never, BaseRespData<never>>(
    '/logistics/logisticsZone/import',
    formData,
    {
      headers: {
        'Content-Type': 'multipart/form-data',
      },
    },
  )
}

//物流分区导入模板
export function exportExcelLogisticsZone() {
  return axios.get<never, BaseRespData<never>>(
    '/logistics/logisticsZone/exportExcel',
    {
      responseType: 'blob',
    },
  )
}

/**
 * @description 运费试算
 */
export function getLogisticsTrialCalculation(params: {
  code?: string
  weight?: string
}) {
  return axios.get<never, BaseRespData<never>>(
    '/logistics/logisticsQuotation/logisticsTrialCalculation',
    {
      params,
    },
  )
}

export function logisticsCompany(data: ILogisticsCompanyData) {
  return axios.get<never, BasePaginationData<ILogisticsCompany>>(
    'logisticsCompany/list_page',
    { params: data },
  )
}

export function logisticsCompanyAdd(data: IForm) {
  return axios.post<never, BaseRespData<never>>('/logisticsCompany/add', data)
}
export function logisticsCompanyUpdate(data: IForm) {
  return axios.post<never, BaseRespData<never>>(
    '/logisticsCompany/update',
    data,
  )
}
export function logisticsCompanyDelete(ids: string | number[]) {
  return axios.get<never, BaseRespData<never>>('/logisticsCompany/delete', {
    params: { ids },
  })
}
export function logisticsCompanyAllCodelist() {
  return axios.get<never, BaseRespData<ILogisticsList[]>>(
    '/logisticsCompany/allCodelist',
  )
}
export function getsortingConfigListApi(
  data: IsortingInfo,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<IsortingInfo>>(
    'logistics/sortingConfig/list_page',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}
export function createSortingApi(data: IsortingInfo) {
  return axios.post<never, BaseRespData<never>>(
    'logistics/sortingConfig/add',
    data,
  )
}
export function updateSortingApi(data: IsortingInfo) {
  return axios.post<never, BaseRespData<never>>(
    'logistics/sortingConfig/update',
    data,
  )
}
export function deleteSortingApi(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    'logistics/sortingConfig/delete',
    {
      params: { ids },
    },
  )
}
