import axios from '@/api/axios'
import { BaseRespData } from '@/types/api'
import { VersionImageList } from '@/types/api/typesetting'

export function getFilePath(fileName?: string) {
  return import.meta.env.BASE_URL + fileName
}
// 上传
export function uploadImg(
  file: File,
  params: { url?: string } & Record<string, string | Blob> = {},
) {
  const from = new FormData()
  from.append('file', file)
  const { url, ...otherParams } = params
  for (const key in otherParams) {
    from.append(key, otherParams[key])
  }
  return axios.post<never, BaseRespData<void> & VersionImageList>(
    url || `upload/ossUpload`,
    from,
    {
      headers: { 'content-type': 'multipart/form-data' },
    },
  )
}
