export interface MenuItem {
  index: string
  id: number
  label: string
  children?: MenuItem[]
}

const menu: MenuItem[] = [
  {
    index: '/dashboard',
    id: 1,
    label: '概览',
  },
  // {
  //   index: '/product',
  //   id: 11,
  //   label: '商品',
  // },
  {
    index: '4',
    id: 7,
    label: '物流',
    children: [
      {
        index: '/logistics/logisticsCompany',
        id: 11,
        label: '物流公司',
      },
      {
        index: '/logistics/logisticsMethod',
        id: 1,
        label: '物流方式',
      },
      {
        index: '/logistics/shippingAddress',
        id: 2,
        label: '发货地址',
      },
      {
        index: '/logistics/logisticsQuotation',
        id: 3,
        label: '物流报价',
      },
      {
        index: '/logistics/declarationRule',
        id: 4,
        label: '申报规则',
      },
      {
        index: '/logistics/logisticsPartition',
        id: 5,
        label: '物流分区',
      },
      {
        index: '/logistics/logisticsCalculate',
        id: 6,
        label: '运费试算',
      },
      {
        index: '/logistics/sortingConfiguration',
        id: 7,
        label: '分拣配置',
      },
      {
        index: '/logistics/logisticsTracking',
        id: 8,
        label: '物流跟踪',
      },
    ],
  },
  {
    index: '13',
    id: 13,
    label: '库存',
    children: [
      {
        index: '/warehouse/warning',
        id: 125,
        label: '仓库预警',
      },
      {
        index: '/warehouse/receipt-doc',
        id: 123,
        label: '入库单',
      },
      {
        index: '/warehouse/issue-doc',
        id: 124,
        label: '出库单',
      },
      {
        index: '/warehouse/manage',
        id: 121,
        label: '仓库管理',
      },
      {
        index: '/warehouse/position',
        id: 122,
        label: '库位管理',
      },
      {
        index: '/warehouse/stocking-plan',
        id: 124,
        label: '备货计划',
      },
    ],
  },

  {
    index: '1',
    id: 2,
    label: '订单',
    children: [
      {
        index: '/order/list',
        id: 1,
        label: '定制订单',
      },
      {
        index: '/pod-order/list',
        id: 7,
        label: 'POD订单',
      },
      {
        index: '/pod-cn-order/list',
        id: 6,
        label: 'POD订单(CN)',
      },
      {
        index: '/pod-us-order/list',
        id: 8,
        label: 'POD订单(US)',
      },
      {
        index: '/pod-cn-order/orderTracking',
        id: 9,
        label: 'POD(CN)订单跟踪',
      },
      {
        index: '/pod-us-order/orderTracking',
        id: 10,
        label: 'POD(US)订单跟踪',
      },
      {
        index: '/pod-us-order/podUsSchedulingRules',
        id: 11,
        label: 'POD(US)排单规则',
      },
    ],
  },

  {
    index: '12',
    id: 4,
    label: '供应',
    children: [
      {
        index: '/supply/supplierManagement',
        id: 1,
        label: '供应商管理',
      },
    ],
  },
  {
    index: '11',
    id: 3,
    label: '对账单',
    children: [
      {
        index: '/account/statement-note',
        id: 1,
        label: '定制对账单',
      },
      {
        index: '/account/pod-bill-order',
        id: 2,
        label: 'POD(CN)对账单',
      },
      {
        index: '/account/pod-us-bill-order',
        id: 3,
        label: 'POD(US)对账单',
      },
    ],
  },
  {
    index: '2',
    id: 4,
    label: '发货单',
    children: [
      {
        index: '/system/delivery-note',
        id: 1,
        label: '定制发货单',
      },
      {
        index: '/pod-delivery-note/list',
        id: 2,
        label: 'POD发货单',
      },
    ],
  },

  {
    index: '/typesetting-management/list',
    id: 5,
    label: '打版管理',
  },
  {
    index: '3',
    id: 6,
    label: '系统设置',
    children: [
      {
        index: '/system/user',
        id: 4,
        label: '用户管理',
      },
      {
        index: '/system/downloadClient',
        id: 4,
        label: '下载生产客户端',
      },
      {
        index: '/system/customers',
        id: 6,
        label: '客户管理',
      },
      {
        index: '/setting/settingIndex',
        id: 8,
        label: '工厂设置',
      },
    ],
  },
  // {
  //   index: '',
  //   id: 3,
  //   label: '生产管理',
  //   children: [
  //     {
  //       index: '/production/complete',
  //       id: 4,
  //       label: '生产完成',
  //     }
  //   ]
  // },
]
export default menu
