import axios from '@/api/axios.ts'
import { BasePaginationData, BaseRespData } from '@/types/api'
import {
  warehouseSearchForm,
  InterWarehousePage,
  InterWarehouseTree,
  InterWarehouseDetail,
  InterskuList,
  ILocation,
  AnyObject,
  InterProductList,
  ExportInWarehouseInfo,
} from '@/types/api/warehouse'
export interface LogListData {
  createTime: string
  description: string
  createdTime?: string | null
}

export interface Address {
  id: number // 主键，自动递增
  shipperName: string // 发货人姓名
  addressLine1: string // 地址 1
  addressLine2?: string | null // 地址 2
  addressLine3?: string | null // 地址 3
  city: string // 城市
  cityCode?: string | null // 城市编码
  district?: string | null // 区
  districtCode?: string | null // 区编码
  cspAccount?: string | null // CSP账号
  stateProvince?: string | null // 州/省
  stateProvinceAbbr?: string | null // 州/省简称
  postalCode?: string | null // 邮编
  countryName: string // 国家名称
  countryCode?: string | null // 国家代码
  phoneNumber?: string | null // 电话
  rfcTaxId?: string | null // RFC税号
  swDefault?: number | null // 是否默认 1是，0不是
  createTime: string // 创建时间
  updateTime: string // 更新时间
}

export interface PrintData {
  code: string
  list: {
    locationName: string
    pickingLocation?: string
    skuName?: string
    warehouseSku?: string
    supplierItemNo?: string
    number?: string
  }[]
}
export interface factoryWarehouseInfo {
  pageSize: number
  currentPage: number
  total?: number
  warehouseId?: string
  locationName?: string
  remark?: string
  idList?: string | number[]
}
export interface factoryLocation {
  locationId?: string
  idList?: string | number[]
}
export interface productNo {
  productNo?: string
  idList?: string | number[]
}
export interface customSku {
  customSku?: string
  idList?: string | number[]
}
export interface ExportFactoryWarehouseInfo {
  pageSize?: number
  currentPage?: number
  total?: number
  warehouseId?: string
  locationName?: string
  remark?: string
  idList?: string | number[]
}

export interface WarehouseInventory {
  pageSize: number
  currentPage: number
  total?: number
  warehouseId: string
  skuName: string
  warehouseSku: string
  occupyInventory: string
  inventoryStart: string
  inventoryEnd: string
  productNo: string
  freezeInventory: string
  inventory: string
  usableInventoryStart: string
  usableInventoryEnd: string
  occupyInventoryEnd: string
  occupyInventoryStart: string
}

export interface UpdateDefaulted {
  id?: number | string
  defaulted: number
}

export interface UpdateStatus {
  id?: number
  status: number | undefined
}

export interface warehouseInfo {
  id?: number | string
  name: string
  code: string
  addressId: string
  sort: string
  defaulted: number
  factoryId?: number
  factoryCode?: string
  remarks: string
}

export interface WarehouseWarning {
  id: number | string
  locationCode: string
  skuName: string
  warehouseSku: string
  productNumber: string
  number: string
  locationName: string
  warehouseId: string | number
  customSku?: string
  productNo?: string
}

export interface positionInfo {
  id?: number
  warehouseId?: string | number
  locationName: string
  pickingOrder: string
  locationCode: string
  warehouseName?: string
  status?: number
  remark: string
}

export interface positionFormInfo {
  id?: number
  warehouseId?: number | string
  locationName: string
  pickingOrder: string
  locationCode: string
  warehouseName: string
  remark: string
  status: number
}
export interface loactionData {
  id?: number
  warehouseId?: number | string
  warehouseName?: string
  locationCode?: number | string
}
interface WarehouseWarningData {
  id: number
  factoryId: number
  warehouseId: number
  warehouseName: string
  warehouseLocationId: number
  locationName: string
  warehouseSku: string
  skuName: string
  unit: string
  occupyInventory: number
  freezeInventory: number
  inventory: number
  upperLimit: number
  floorLimit: number
  productNumber: string
  itemSort: number
  dataVersion: number
  status: number
  createTime: string
  updateTime: string
}

export function getFactoryLocation(data: factoryWarehouseInfo) {
  return axios.post<never, BasePaginationData<positionInfo>>(
    'factoryWarehouseLocation/list_page',
    data,
  )
}
// 修改库位
export function updateLocationApi(data: factoryLocation) {
  return axios.post<never, BasePaginationData<never>>(
    'factoryWarehouseInventory/updateLocation',
    data,
  )
}
// 修改款号
export function updateProductNoApi(data: productNo) {
  return axios.post<never, BasePaginationData<never>>(
    'factoryWarehouseInventory/updateProductNo',
    data,
  )
}
// 修改自定义sku
export function updateCustomSkuApi(data: customSku) {
  return axios.post<never, BasePaginationData<never>>(
    'factoryWarehouseInventory/updateCustomSku',
    data,
  )
}

export function exportWarehouseInfo(data: ExportFactoryWarehouseInfo) {
  return axios.post<never, BasePaginationData<positionInfo>>(
    'factoryWarehouseInventory/inventory',
    data,
  )
}

export function getFactoryWarehouseInfo(data: factoryWarehouseInfo) {
  return axios.post<never, BasePaginationData<warehouseInfo>>(
    'factoryWarehouseInfo/list_page',
    data,
  )
}

export function getWarehouseInventoryInfo(data: WarehouseInventory) {
  return axios.post<never, BasePaginationData<WarehouseWarning>>(
    'factoryWarehouseInventory/list_page',
    data,
  )
}

export function createWarehouseApi(data: warehouseInfo) {
  return axios.post<never, BaseRespData<never>>(
    '/factoryWarehouseInfo/add',
    data,
  )
}

export function factoryLogWarehouseLog(id: number | string | undefined) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    '/factoryLogWarehouse/get',
    { params: { id } },
  )
}

export function factoryWarehouseInfoPrint(data: PrintData) {
  return axios.post<never, BaseRespData<never[]>>(
    '/factoryWarehouseInfo/print',
    data,
  )
}

export function importWarehouseLocation(data: FormData) {
  return axios.post<never, BaseRespData<never[]>>(
    '/factoryWarehouseLocation/importWarehouseLocation',
    data,
  )
}

export function factoryWarehouseInventoryPrint(data: PrintData) {
  return axios.post<never, BaseRespData<never[]>>(
    '/factoryWarehouseInventory/print',
    data,
  )
}
export function createPositionApi(data: positionInfo) {
  return axios.post<never, BaseRespData<never>>(
    '/factoryWarehouseLocation/add',
    data,
  )
}

export function warehouseInfoGetAll() {
  return axios.get<never, BaseRespData<warehouseInfo[]>>(
    '/factoryWarehouseInfo/getAll',
  )
}
export function LocationInfoGetAll(wareHouseId?: string | number) {
  return axios.get<never, BaseRespData<loactionData[]>>(
    '/factoryWarehouseLocation/getByWareHouse',
    {
      params: { wareHouseId },
    },
  )
}

export function createWarehouseInventoryApi(data: WarehouseWarningData) {
  return axios.post<never, BaseRespData<never>>(
    '/factoryWarehouseInventory/add',
    data,
  )
}

export function updateWarehouseApi(data: positionInfo | UpdateDefaulted) {
  return axios.post<never, BaseRespData<never>>(
    '/factoryWarehouseInfo/update',
    data,
  )
}

export function logisticsAddressGetAllList() {
  return axios.get<never, BaseRespData<Address[]>>(
    '/logisticsAddress/getAllList',
  )
}

export function updatePositionApi(data: positionInfo) {
  return axios.post<never, BaseRespData<never>>(
    '/factoryWarehouseLocation/update',
    data,
  )
}

export function updatePositionStatusApi(data: UpdateStatus) {
  return axios.get<never, BaseRespData<never>>(
    '/factoryWarehouseLocation/updateStatus',
    { params: data },
  )
}

export function updateWarehouseInventoryApi(data: WarehouseWarningData) {
  return axios.post<never, BaseRespData<never>>(
    '/factoryWarehouseInventory/update',
    data,
  )
}

export function deleteWarehouseApi(ids: string) {
  return axios.get<never, BaseRespData<never>>('/factoryWarehouseInfo/delete', {
    params: { ids },
  })
}

export function deleteLocationApi(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    '/factoryWarehouseLocation/delete',
    {
      params: { ids },
    },
  )
}

export function deleteWarehouseInventory(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    '/factoryWarehouseInventory/delete',
    {
      params: { ids },
    },
  )
}
// 入库单
export function InRecordBatchCheckPrintApi(ids: string) {
  return axios.get<never, BaseRespData<never[]>>(
    'factory/warehouseInRecord/batchCheckPrint',
    {
      params: { ids },
    },
  )
}
export function warehouseInRecordExport(data: ExportInWarehouseInfo) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/warehouseInRecord/export',
    data,
  )
}
export function warehouseInRecordListPageApi(
  data: warehouseSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<InterWarehousePage>>(
    '/factory/warehouseInRecord/list_page',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}
export function rejectInRecordApi({
  list,
  rejectReason,
}: {
  list: WarehouseParams[]
  rejectReason: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/warehouseInRecord/reject',
    {
      list,
      rejectReason,
    },
  )
}
export function addInRecordApi(form: InterWarehouseDetail) {
  return axios.post<never, BaseRespData<never>>(
    'factory/warehouseInRecord/add',
    {
      ...form,
    },
  )
}
export function exportOrder(ids: number[], status: string | number) {
  return axios.post<never, BaseRespData<never>>(
    'factory/warehouseInRecord/exportData',
    { ids: ids, status },
  )
}
export function updateInRecordApi(
  form: InterWarehouseDetail | AnyObject | null,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/warehouseInRecord/update',
    {
      ...form,
    },
  )
}
export function getWarehouseInRecordDetailApi(id: number | undefined) {
  return axios.get<never, BaseRespData<InterWarehouseDetail>>(
    'factory/warehouseInRecord/get',
    {
      params: {
        id,
      },
    },
  )
}
export function getBySkuApi(
  warehouseId: number | string | undefined,
  sku: string | null,
) {
  return axios.post<never, BaseRespData<InterskuList[]>>(
    'customProductItem/getBySku',
    {
      warehouseId,
      sku,
    },
  )
}
export function getByWareHouseIdAndCodeApi(
  wareHouseId: number | string | undefined,
  code: string | null,
) {
  return axios.get<never, BaseRespData<ILocation[]>>(
    'factoryWarehouseLocation/getByWareHouseIdAndCode',
    {
      params: {
        wareHouseId,
        code,
      },
    },
  )
}
export function getInRecordStatusTree() {
  return axios.get<never, BaseRespData<InterWarehouseTree[]>>(
    'factory/warehouseInRecord/status_tree',
  )
}

interface WarehouseParams {
  id?: number
  dataVersion?: number
}
export function auditOrderApi(url: string, data: WarehouseParams[]) {
  return axios.post(url, data)
}
export function deleteWarehouseInRecordApi(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    'factory/warehouseInRecord/delete',
    {
      params: { ids },
    },
  )
}
export function getInRecordLogApi(inRecordId?: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    `factory/warehouseInRecord/log/${inRecordId}`,
  )
}
// 出库单
export function warehouseOutRecordExport(data: ExportInWarehouseInfo) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/warehouseOutRecord/export',
    data,
  )
}
export function OutRecordBatchCheckPrintApi(ids: string) {
  return axios.get<never, BaseRespData<never[]>>(
    'factory/warehouseOutRecord/batchCheckPrint',
    {
      params: { ids },
    },
  )
}
export function getOutRecordStatusTree() {
  return axios.get<never, BaseRespData<InterWarehouseTree[]>>(
    'factory/warehouseOutRecord/status_tree',
  )
}
export function getBySkuAndWarehouseIdApi(
  warehouseId: number | string | undefined,
  sku: string | null,
) {
  return axios.get<never, BaseRespData<InterskuList[]>>(
    'factoryWarehouseInventory/getBySkuAndWarehouseId',
    {
      params: {
        warehouseId,
        sku,
      },
    },
  )
}
export function rejectOutRecordApi({
  list,
  rejectReason,
}: {
  list: WarehouseParams[]
  rejectReason: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/warehouseOutRecord/reject',
    {
      list,
      rejectReason,
    },
  )
}
export function getItemListByIdApi(id: number | undefined) {
  return axios.get<never, BaseRespData<InterProductList[]>>(
    'factory/warehouseOutRecord/getItemListById',
    {
      params: {
        id,
      },
    },
  )
}
export function getWarehouseOutRecordDetailApi(id: number | undefined) {
  return axios.get<never, BaseRespData<InterWarehouseDetail>>(
    'factory/warehouseOutRecord/get',
    {
      params: {
        id,
      },
    },
  )
}
export function addOutRecordApi(form: InterWarehouseDetail) {
  return axios.post<never, BaseRespData<never>>(
    'factory/warehouseOutRecord/add',
    {
      ...form,
    },
  )
}
export function updateOutRecordApi(
  form: InterWarehouseDetail | AnyObject | null,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/warehouseOutRecord/update',
    {
      ...form,
    },
  )
}
export function getOutRecordLogApi(id?: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    `factory/warehouseOutRecord/getLogById?id=${id}`,
  )
}
export function warehouseOutRecordListPage(
  data: warehouseSearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<InterWarehousePage>>(
    'factory/warehouseOutRecord/list_page',
    {
      ...data,
      currentPage,
      pageSize,
    },
  )
}
export function deleteWarehouseOutRecordApi(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    'factory/warehouseOutRecord/delete',
    {
      params: { ids },
    },
  )
}
