/**
 * @type {import("vue/types/options").DirectiveOptions}
 */
const enterSubmit = {
  inserted: (el, binding) => {
    el._enterSubmitFn = (e) => {
      if (e.key !== 'Enter') return
      if (typeof binding.value === 'function') {
        setTimeout(() => {
          binding.value()
        }, 100)
      }
    }

    el.addEventListener('keydown', el._enterSubmitFn, true)
  },
  unbind: (el) => {
    el.removeEventListener(
      'keydown',
      el._enterSubmitFn,
      true,
    )
  },
}

export default enterSubmit
