/*
 * @Description: 描述
 * @Author: chd
 * @Date: 2021-01-18 13:49:02
 * @LastEditors: chd
 * @LastEditTime: 2021-04-27 21:40:51
 */

import { post } from '@/common/api/axios.js'

/**
 * 上传图片
 * @param {*} params
 * @param {String} params.filePath - 文件存储文件夹
 * @param {object} ...other
 * @returns Promise
 */
export function uploadImg(file, params = {}) {
  const from = new FormData()
  from.append('file', file)
  const { url, ...otherParams } = params
  for (const key in otherParams) {
    from.append(key, otherParams[key])
  }
  return post(url || 'upload/fileUpload/images', from, {
    // headers: { 'content-type': 'multipart/form-data' }
  })
}
export function uploadOtherFile(params) {
  const { url, name, file, ...other } = params
  const from = new FormData()
  for (const key in other) {
    from.append(key, other[key])
  }
  from.append(name, file)
  return post(url, from, {
    headers: { 'content-type': 'multipart/form-data' }
  })
}
