import Vue from 'vue'
import Vuex from 'vuex'

import tags from './tags'
// import { getLoginState } from '@/common/api/login'
import { getUser } from '@/utils/auth'
Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    keyCode: null,
    userInfo: getUser(),
  },
  getters: {},
  mutations: {
    setKeyCode(state, msg) {
      state.keyCode = msg
    },
    setUserInfo(state, profile) {
      console.log(profile)
      state.userInfo = profile
    },
  },
  actions: {
    setKeyCode({ commit }, msg) {
      commit('setKeyCode', msg)
    },
  },
  modules: {
    tags,
  },
})
