import Vue from 'vue'
import VueRouter from 'vue-router'
import HomeView from '../views/home/HomeView.vue'
import SaasManage from '@/views/saasManage/indexPage.vue'
import LoginPage from '@/views/LoginPage.vue'
import menuPage from '@/views/menu.vue'
import TaskManage from '@/views/taskManage/index.vue'
import HomePage from '@/views/homePage/index.vue'
import { getToken } from '@/utils/auth'
export const DEFAULT_DASHBOARD = 'home'

Vue.use(VueRouter)

const routes = [
  {
    path: '/login',
    name: 'login',
    component: LoginPage
  },

  {
    path: '/',
    name: 'home',
    component: HomeView,
    redirect: '/saas/home',
    children: [
      {
        path: '/saas/home',
        name: 'home',
        component: HomePage,
        meta: { title: '首页' }
      },
      {
        path: '/saas/manage',
        name: 'saasManage',
        meta: { title: 'ERP管理' },
        component: SaasManage
      },
      {
        path: '/saas/menu',
        component: menuPage,
        name: 'saasMenu',
        meta: { title: '菜单管理' }
      },
      {
        path: '/saas/taskManage',
        component: TaskManage,
        name: 'taskManage',
        meta: { title: '工单管理' }
      },
      {
        path: '/saas/user',
        component: () => import('@/views/system/users.vue'),
        name: 'system_user',
        meta: { title: '用户管理' }
      },
      {
        path: '/saas/currency',
        component: () => import('@/views/basics/currency.vue'),
        name: 'basics_currency',
        meta: { title: '汇率币种' }
      },
      {
        path: '/saas/timed_task',
        component: () => import('@/views/system/timed_task.vue'),
        name: 'system_timed_task',
        meta: { title: '定时任务' }
      },
      {
        path: '/saas/announceManage',
        component: () => import('@/views/system/announceManage.vue'),
        name: 'system_announce_manage',
        meta: { title: '公告管理' }
      },
      {
        path: '/saas/services',
        component: () => import('@/views/system/services.vue'),
        name: 'system_services',
        meta: { title: '服务管理' }
      },
      {
        path: '/saas/sysSecuritySettings',
        component: () => import('@/views/system/sysSecuritySettings.vue'),
        name: 'system_security_settings',
        meta: { title: '安全设置中心' }
      },
      {
        path: '/saas/erpManagementList',
        component: () => import('@/views/system/erpManagementList.vue'),
        name: 'erpManagementList',
        meta: { title: 'ERP启动列表' }
      },
      {
        path: '/saas/countryCode',
        component: () => import('@/views/system/countryCode.vue'),
        name: 'system_countryCode',
        meta: { title: '国家代码' }
      },
      {
        path: '/saas/abbreviation',
        component: () => import('@/views/system/abbreviation.vue'),
        name: 'system_abbreviation',
        meta: { title: '州省简称' }
      },
      {
        path: '/saas/user/management',
        component: () => import('@/views/user/management.vue'),
        name: 'system_management',
        meta: { title: '客户管理' }
      },

      {
        path: '/saas/user/recharge-record',
        component: () => import('@/views/user/rechargeRecord.vue'),
        name: 'user_recharge_record',
        meta: { title: '充值记录' }
      },
      {
        path: '/saas/user/base_proceeds_account',
        component: () => import('@/views/user/baseProceedsAccount.vue'),
        name: 'base_proceeds_account',
        meta: { title: '收款账户管理' }
      },
      {
        path: '/saas/logistics/transporters',
        component: () => import('@/views/system/transporters.vue'),
        name: 'system_transporters',
        meta: { title: '运输商列表' }
      },
      {
        path: '/saas/category-style',
        component: () => import('@/views/system/category-style.vue'),
        name: 'system_category_style',
        meta: { title: '类别风格' }
      },
      {
        path: '/saas/sku-sort',
        component: () => import('@/views/system/sku-sort.vue'),
        name: 'system_sku-sort',
        meta: {
          title: '属性类管理'
        }
      },
      {
        path: '/saas/sku-manage',
        component: () => import('@/views/system/sku-manage.vue'),
        name: 'system_sku-manage',
        meta: {
          title: '属性值管理'
        }
      },
      {
        path: '/saas/app',
        component: () => import('@/views/system/app.vue'),
        name: 'app_management',
        meta: {
          title: '应用中心'
        }
      },
      {
        path: '/operation/lossOrder',
        component: () => import('@/views/operation/lossOrder/index.vue'),
        name: 'system_management',
        meta: { title: '丢单管理' }
      },
      {
        path: '/operation/exceptionMessage',
        component: () => import('@/views/operation/exceptionMessage.vue'),
        name: 'exceptionMessage',
        meta: { title: '异常消息' }
      },
      {
        path: '/operation/asynchronousTask',
        component: () => import('@/views/operation/asynchronousTask.vue'),
        name: 'asynchronousTask',
        meta: { title: '异步任务' }
      },
      {
        path: '/operation/amazonAttributeGrouping',
        component: () => import('@/views/operation/amazon/amazonAttributeGrouping.vue'),
        name: 'amazonAttributeGrouping',
        meta: { title: '亚马逊属性分类' }
      },
      {
        path: '/saas/production/assistant/manage',
        component: () => import('@/views/production/AssistantManage.vue'),
        name: 'production_assistant_manage',
        meta: { title: '应用版本管理' }
      },
      {
        path: '/saas/import-template',
        component: () => import('@/views/import-template/index.vue'),
        name: 'import-template',
        meta: { title: '亚马逊导入模板' }
      },
      {
        path: '/dynamicForm',
        component: () => import('@/components/dynamicForms/index.vue'),
        name: 'system_management',
        meta: { title: '动态表单' }
      }
    ]
  }
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})
// 导航守卫
router.beforeEach((to, from, next) => {
  const token = getToken()
  if (to.name === 'home' && !token) {
    // 如果用户尝试访问首页但没有token，则重定向到登录页
    next('/login')
  } else if (to.name === 'login' && token) {
    // 如果用户已经在登录状态且尝试访问登录页，则重定向到首页
    next('/')
  } else {
    // 其他情况，正常放行
    next()
  }
})
// 修改 Vue Router 的 push 方法，使其在发生异常时不会抛出错误，而是返回一个包含错误信息的 Promise
const VueRouterPush = VueRouter.prototype.push
VueRouter.prototype.push = function push(to) {
  return VueRouterPush.call(this, to).catch((err) => err)
}

export default router
