import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import './plugins/myui'
import element from '@/common/components/element-ui.js'
import vxeTable from 'vxe-table'
import 'xe-utils'
import 'vxe-table/lib/index.css'
import './common/style/index.scss'
import './assets/css/common.css'
import './assets/css/root.css'
import Directives from './utils/directives'
import { filePath, zImgPath } from './utils/commonUtil'
import md5 from 'js-md5'
import _ from 'lodash'
// import { getToken } from '@/utils/auth'

Vue.config.productionTip = false
Vue.use(Directives)

Vue.use(element)
Vue.use(vxeTable)

const clientWidth = document.body.clientWidth
const dpi = _.add(_.ceil(_.divide(clientWidth / 1920)) + 0.5)
let imagePath = ''
if (md5(location.host) === '42f2b26039d7fd526b8a1d50bb329cbc') {
  localStorage.setItem('locationHost', location.host)
  imagePath = zImgPath
} else if (zImgPath.indexOf('/erpimg') !== -1) {
  imagePath = zImgPath
} else {
  imagePath = 'https://image.jomalls.com/'
}
Vue.prototype.setimgUrl = (url, options = {}) => {
  const { w, h, ...others } = options
  let query = ''
  if (w) {
    query += query ? '&w=' : 'w=' + _.floor(_.multiply(dpi * w))
  }
  if (h) {
    query += query ? '&h=' : 'h=' + _.floor(_.multiply(dpi * h))
  }
  for (const key in others) {
    query += `${query ? '&' : ''}${key}=${options[key]}`
  }

  if (!url) return ''
  if (/((http|https):)?\/\/([^/]+)/i.test(url)) {
    return url
  } else if (url.indexOf('/') === -1) {
    return imagePath + url + (query ? '?' : '') + query
  } else {
    return filePath + url
  }
}

router.afterEach((to, from) => {
  if (to.path === '/login') return
  store.commit('tags/add', {
    name: to.name,
    path: to.fullPath,
    title: to.meta?.title || to.name,
    meta: to.meta
  })
  store.commit('tags/setActive', to.name)
})

router.beforeEach((to, form, next) => {
  // const auth = getToken()
  // if (!auth && to.path !== '/login') {
  //   next({ path: '/login' })
  // } else {
  //   next()
  // }
  next()
})

new Vue({
  router,
  store,
  render: (h) => h(App)
}).$mount('#app')
