class MyDropPanelMenu {
  constructor() {
    this.title = '插入参数'
    // this.iconSvg = '<svg >...</svg>'
    this.tag = 'button'
    this.showDropPanel = true
  }
  // 菜单是否需要激活（如选中加粗文本，“加粗”菜单会激活），用不到则返回 false

  isActive() {
    return false
  }
  // 获取菜单执行时的 value ，用不到则返回空 字符串或 false

  getValue() {
    return ''
  }
  // 菜单是否需要禁用（如选中 H1 ，“引用”菜单被禁用），用不到则返回 false

  isDisabled() {
    return false
  }
  // 点击菜单时触发的函数

  exec() {
    // DropPanel menu ，这个函数不用写，空着即可
  }

  // 定义 DropPanel 内部的 DOM Element

  getPanelContentElem(editor) {
    const list = document.createElement('ul')
    list.classList.add('panel_menu')
    const { options } = editor.getMenuConfig('insertSelect')
    let html = ''
    for (const iterator of options) {
      html += `<li style="line-height:28px;cursor: pointer;" data-value="${iterator.value}">${iterator.label}</li>`
    }
    list.innerHTML = html

    list.addEventListener('click', (e) => {
      if (e.target.nodeName === 'LI') {
        const value = e.target.dataset.value
        if (value) {
          editor.insertText(value)
          editor.insertText(' ')
        }
      }
    })

    return list // 返回 DOM Element 类型

    // PS：也可以把 $list 缓存下来，这样不用每次重复创建、重复绑定事件，优化性能
  }
}
const insetSelect = {
  key: 'insertSelect', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new MyDropPanelMenu() // 把 `YourMenuClass` 替换为你菜单的 class
  },
  config: {
    options: [],
  },
}
export default insetSelect