
class EditSourceCode {
  constructor() {
    this.title = '代码' // 自定义菜单标题
    this.iconSvg = `<svg  
    t="1644825421859"
    class="active"
     viewBox="0 0 1024 1024"
      version="1.1"
       xmlns="http://www.w3.org/2000/svg"
        p-id="9348" width="18" height="18">
        <path 
        d="M875.52 89.6H148.48c-33.792 0-61.44 27.648-61.44 61.44v721.92c0 33.792 27.648 61.44 61.44 61.44h727.04c33.792 0 61.44-27.648 61.44-61.44v-721.92c0-33.792-27.648-61.44-61.44-61.44z m20.48 783.36c0 11.1104-9.3696 20.48-20.48 20.48H148.48c-11.1104 0-20.48-9.3696-20.48-20.48v-568.32h768v568.32z m0-609.28H128v-112.64c0-11.1104 9.3696-20.48 20.48-20.48h727.04c11.1104 0 20.48 9.3696 20.48 20.48v112.64z" 
        fill="#1e88e5" p-id="9349"></path>
        <path 
        d="M215.04 204.8m-20.48 0a20.48 20.48 0 1 0 40.96 0 20.48 20.48 0 1 0-40.96 0Z" 
        fill="#1e88e5" p-id="9350"></path>
        <path d="M291.84 204.8m-20.48 0a20.48 20.48 0 1 0 40.96 0 20.48 20.48 0 1 0-40.96 0Z" 
        fill="#1e88e5" p-id="9351">
        </path><path 
        d="M368.64 204.8m-20.48 0a20.48 20.48 0 1 0 40.96 0 20.48 20.48 0 1 0-40.96 0Z"
         fill="#1e88e5" p-id="9352"></path>
         <path d="M196.7616 621.6192l129.8432 129.8432c6.912 6.912 17.8688 8.5504 26.0608 3.2256 11.2128-7.3728 12.3904-22.7328 3.3792-31.6928L243.8656 610.816c-2.816-2.816-2.816-7.3216 0-10.0864L355.584 488.96c6.912-6.912 8.5504-17.8688 3.2256-26.0608-7.3728-11.2128-22.7328-12.3904-31.6928-3.3792L196.7616 589.824c-4.352 4.352-11.3664 10.1888-10.9568 15.872-0.3584 5.7344 6.656 11.5712 10.9568 15.9232zM780.1344 600.6784c2.816 2.816 2.816 7.3216 0 10.0864l-112.1792 112.1792c-8.96 8.96-7.8336 24.3712 3.3792 31.6928 8.192 5.3248 19.1488 3.6864 26.0608-3.2256l129.8432-129.8432c4.352-4.352 11.3664-10.1888 10.9568-15.872 0.4096-5.6832-6.6048-11.52-10.9568-15.872l-130.304-130.304c-8.96-8.96-24.3712-7.8336-31.6928 3.3792-5.3248 8.192-3.6864 19.1488 3.2256 26.0608l111.6672 111.7184zM430.2336 786.432c10.1888 4.8128 22.4768 0.4096 27.2896-9.7792l146.0224-308.8896c4.8128-10.1888 0.4096-22.4768-9.7792-27.2896a20.56704 20.56704 0 0 0-27.2896 9.7792l-146.0224 308.8896a20.56704 20.56704 0 0 0 9.7792 27.2896z" 
        fill="#1e88e5" 
        p-id="9353"></path>
        </svg>` // 可选
    this.tag = 'button'
    this.active = false
  }

  // 获取菜单执行时的 value ，用不到则返回空 字符串或 false

  getValue(editor) {
    return this.active ? editor.getText() : editor.getHtml()
  }

  // 菜单是否需要激活（如选中加粗文本，“加粗”菜单会激活），用不到则返回 false

  isActive() {
    return this.active
  }

  // 菜单是否需要禁用（如选中 H1 ，“引用”菜单被禁用），用不到则返回 false

  isDisabled() {
    return false
  }

  // 点击菜单时触发的函数

  exec(editor, value) {
    if (this.isDisabled(editor)) return
    console.log(value)
    this.active = !this.active
    if (this.active) {
      value = value
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/ /g, '&nbsp;')
    } else {
      value = value
        .replace(/&lt;/gi, '<')
        .replace(/&gt;/gi, '>')
        .replace(/&nbsp;/gi, ' ')
    }
    console.log(value)
    editor.setHtml(value) // value 即 this.value(editor) 的返回值
  }
}
const editCode = {
  key: 'editCode', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new EditSourceCode() // 把 `YourMenuClass` 替换为你菜单的 class
  },
}

export default editCode
