import 'element-ui/lib/theme-chalk/index.css'

import {
  Button,
  Table,
  TableColumn,
  Dialog,
  Form,
  FormItem,
  Input,
  Message,
  MessageBox,
  Pagination,
  Loading,
  Row,
  Col,
  DatePicker,
  Switch,
  Select,
  Option,
  Cascader,
  Radio,
  RadioGroup,
  Menu,
  Submenu,
  MenuItem,
  MenuItemGroup,
  Tag,
  Checkbox,
  Tabs,
  TabPane,
  Tree,
  Dropdown,
  DropdownItem,
  DropdownMenu,
  Tooltip,
  ColorPicker,
  CheckboxGroup,
  Divider,
  Popover,
  Upload,
  Descriptions,
  DescriptionsItem,
  InputNumber,
  Link
} from 'element-ui'

const components = [
  Button,
  Table,
  TableColumn,
  Dialog,
  Form,
  FormItem,
  Input,
  DatePicker,
  Pagination,
  Switch,
  Select,
  Option,
  Cascader,
  Radio,
  RadioGroup,
  Menu,
  MenuItem,
  Submenu,
  MenuItemGroup,
  Tabs,
  Row,
  Col,
  TabPane,
  Tag,
  Checkbox,
  Tree,
  Dropdown,
  DropdownItem,
  DropdownMenu,
  Divider,
  Tooltip,
  ColorPicker,
  CheckboxGroup,
  Popover,
  Upload,
  Descriptions,
  DescriptionsItem,
  InputNumber,
  Link
]

export default {
  install(Vue) {
    components.forEach((c) => {
      Vue.component(c.name, c)
    })
    Vue.use(Loading)
    Vue.prototype.$message = (message) =>
      typeof message === 'string'
        ? Message({
            duration: 2500,
            message
          })
        : Message({
            duration: 2500,
            ...message
          })
    Vue.prototype.$message.success = (message) =>
      typeof message === 'string'
        ? Message.success({ duration: 2500, message })
        : Message.success({ duration: 2500, ...message })
    Vue.prototype.$message.warning = (message) =>
      typeof message === 'string'
        ? Message.warning({ duration: 2500, message })
        : Message.warning({ duration: 2500, ...message })
    Vue.prototype.$message.info = (message) =>
      typeof message === 'string'
        ? Message.info({ duration: 2500, message })
        : Message.info({ duration: 2500, ...message })
    Vue.prototype.$message.error = (message) =>
      typeof message === 'string'
        ? Message.error({ duration: 2500, message })
        : Message.error({ duration: 2500, ...message })
    Vue.prototype.$msgbox = MessageBox
    Vue.prototype.$alert = MessageBox.alert
    Vue.prototype.$confirm = MessageBox.confirm
    Vue.prototype.$prompt = MessageBox.prompt
  }
}
