import axios from '../axios'

export function getUserRechargeRecordListApi(params) {
  return axios.post('/pay/businessPayRecord/list_page', params)
}
export function getSubjectListApi(params) {
  return axios.get('/pay/businessPayRecord/subjectList', params)
}

// 收款账户管理 获取账户类型
export function getAccountTypeListApi() {
  return axios.get('/baseProceedsAccount/accountTypeList')
}

// 收款账户管理 获取收款方式
export function getReceiverTypeListApi() {
  return axios.get('/baseProceedsAccount/receiverTypeList')
}

// 收款账户管理 获取收款方式
export function getBusinessTypeListApi() {
  return axios.get('/baseProceedsAccount/businessTypeList')
}

// 收款账户管理 获取币种
export function getCurrencyTypeListApi() {
  return axios.get('/manage/rest/baseCurrencyInfo/uniList')
}

// 收款账户管理 获取安全设置
export function getSecuritySettingApi() {
  return axios.get('/sysSecuritySettings/getOne')
}

// 收款账户管理 获取收款账户列表
export function getBaseProceedsAccountListApi(params) {
  return axios.post('/baseProceedsAccount/list_page', params)
}

// 获取收款账户详情
export function getBaseProceedsAccountDetailApi(id) {
  return axios.get(`/baseProceedsAccount/get?id=${id}`)
}

// 获取收款账户操作日志
export function getBaseProceedsAccountLogApi(id) {
  return axios.get(`/baseProceedsAccountLog/getList?relaId=${id}`)
}

// 收款账户管理 更新收款账户启用状态
export function updateBaseProceedsAccountEnableApi(params) {
  return axios.post('/baseProceedsAccount/updateEnable', params)
}

// 收款账户管理 新增收款账户
export function addBaseProceedsAccountApi(params) {
  return axios.post('/baseProceedsAccount/add', params)
}

// 收款账户管理 更新收款账户
export function updateBaseProceedsAccountApi(params) {
  return axios.post('/baseProceedsAccount/update', params)
}

// 收款账户管理 删除收款账户
export function deleteBaseProceedsAccountApi(params) {
  return axios.post('/baseProceedsAccount/delete', params)
}

// 收款账户管理 发送手机验证码
export function sendPhoneCodeApi(params) {
  return axios.post('/sysSecuritySettings/sendPhoneCode', params)
}

// 收款账户管理 发送邮箱验证码
export function sendEmailCodeApi(email, operateType) {
  return axios.get(
    `/sysSecuritySettings/sendEmailCode?email=${email}&operateType=${operateType}`
  )
}

// 收款账户管理 获取授权链接
export function getAuthLinkApi(id) {
  return axios.get(`/baseProceedsAccount/authData?id=${id}`)
}
