import axios from './axios'

export function getOrderTree() {
  return axios.get(
    'platform/platformWorkOrder/saas/findStateGroupList',
  )
}

export function workConfirmed(id) {
  return axios.post(
    'platform/platformWorkOrder/confirmed',
    {
      id: id,
    },
  )
}

export function workAssigned(data) {
  return axios.post(
    'platform/platformWorkOrder/assign',
    data,
  )
}
export function reallocate(data) {
  return axios.post(
    'platform/platformWorkOrder/reallocate',
    data,
  )
}
export function startWorder(id, estimateCompleteTime) {
  return axios.post('platform/platformWorkOrder/start', {
    id: id,
    estimateCompleteTime: estimateCompleteTime,
  })
}

export function archiveWorkOrder(id) {
  return axios.post('platform/platformWorkOrder/archive', {
    id: id,
  })
}

// export function completeWorkOrder(id) {
//   return axios.post('platform/platformWorkOrder/complete', {
//     id: id,
//   })
// }
export function completeWorkOrder(id) {
  return axios.post(
    'platform/platformWorkOrder/intoAcceptance',
    {
      id: id,
    },
  )
}
export function acceptanWorkOrder(data) {
  return axios.post(
    'platform/platformWorkOrder/acceptance',
    data,
  )
}
export function PendingWorkOrder(data) {
  return axios.post(
    'platform/platformWorkOrder/closeForPending',
    data,
  )
}

export function ShelveWorkOrder(data) {
  return axios.post(
    'platform/platformWorkOrder/shelveForPending',
    data,
  )
}
export function TurnBackToPending(data) {
  return axios.post(
    'platform/platformWorkOrder/turnBackToPending',
    data,
  )
}

export function replyTocustomer(id, msg) {
  return axios.post('platform/platformWorkOrderChat/add', {
    msg: msg,
    workOrderId: id,
  })
}

export function getOrderType() {
  return axios.get(
    'platform/platformWorkOrder/orderTypeList',
  )
}
export function resume(id) {
  return axios.post('platform/platformWorkOrder/resume', {
    id: id,
  })
}
export function pause(id) {
  return axios.post('platform/platformWorkOrder/pause', {
    id: id,
  })
}
export function reject(id) {
  return axios.post('platform/platformWorkOrder/reject', {
    id: id,
  })
}
export function closeForPending(id) {
  return axios.post(
    'platform/platformWorkOrder/closeForPending',
    {
      id: id,
    },
  )
}
export function close(id) {
  return axios.post('platform/platformWorkOrder/close', {
    id: id,
  })
}
export function getInfo(id) {
  return axios.get(
    'platform/platformWorkOrder/get?id=' + id,
  )
}
