import axios from '../axios'

export function getManageData(
  { ym, status, companyName, user, beginDate, endDate, timeProp },
  currentPage,
  pageSize
) {
  return axios.post('/sys/domain/list_page', {
    ym,
    status,
    companyName,
    user,
    beginDate,
    endDate,
    timeProp,
    currentPage,
    pageSize
  })
}
export function addGiftOrders(data) {
  return axios.post('/sys/domain/addGiftOrders', data)
}
export function addManageData(data) {
  return axios.post('/sys/domain/add', data)
}

export function updateManageData(data) {
  return axios.post('/sys/domain/update', data)
}

export function getDataById(id) {
  return axios.get('/sys/domain/get', {
    params: { id }
  })
}
export function getLogById(datasourceId) {
  return axios.get('/sys/domain/log', {
    params: { datasourceId }
  })
}

export function deleteData(ids) {
  return axios.get('/sys/domain/delete', {
    params: { ids }
  })
}

export function getStatusSelect() {
  return axios.get('/sys/domain/getErpStatusList')
}
export function reOpenErp(id) {
  return axios.post(`/sys/domain/reopen/${id}`)
}
